/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import java.util.Vector;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.part.PageBook;

public class Workbook
implements SelectionListener {
    protected TabFolder tabFolder;
    protected PageBook pageBook;
    protected Vector pages = new Vector();

    public Workbook(Composite parent) {
        this(parent, 0);
    }

    public Workbook(Composite parent, int style) {
        this.tabFolder = new TabFolder(parent, style);
        this.tabFolder.setLayoutData((Object)ViewUtility.createFill());
        this.pageBook = new PageBook((Composite)this.tabFolder, style);
        this.pageBook.setLayoutData((Object)ViewUtility.createFill());
        this.tabFolder.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Workbook.this.pageBook.setBounds(Workbook.this.tabFolder.getClientArea());
            }
        });
    }

    public Composite getClientComposite() {
        return this.pageBook;
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    public PageBook getPageBook() {
        return this.pageBook;
    }

    public void addPage(Control page, String label, Image image, String toolTipText) {
        this.tabFolder.removeSelectionListener((SelectionListener)this);
        TabItem item = new TabItem(this.tabFolder, 0);
        if (label != null) {
            item.setText(label);
        }
        if (image != null) {
            item.setImage(image);
        }
        if (toolTipText != null) {
            item.setToolTipText(toolTipText);
        }
        this.pages.add(page);
        if (this.pages.size() == 1) {
            this.pageBook.showPage(page);
        }
        this.tabFolder.addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        int i = this.tabFolder.getSelectionIndex();
        this.pageBook.showPage((Control)this.pages.get(i));
    }
}

