/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.ConstantExpressionWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class NumericConstantBuilderPage
extends WizardPage
implements SelectionListener {
    protected SQLQueryObject sqlStatement;
    private Composite mainPanel;
    private Text constantText;
    private QueryValueExpression inputSQLExpression;
    private QueryValueExpression updatedSQLExpression;
    private static final String REGEX_TEMP = "[+-]|\\.|[+-].|([+-]?((\\d+(\\.?\\d*)?)|(\\.?\\d+))([eE][+-]?\\d*)?)";
    private static final String REGEX_FINAL = "[+-]?((\\d+(\\.\\d*)?)|(\\.\\d+))([eE][+-]?\\d+)?";
    private static final String DEFAULT_TEXT = "0";
    private Button clearButton;

    public NumericConstantBuilderPage(SQLQueryObject sqlStatementArg, QueryValueExpression sqlExpr) {
        super(Messages._UI_WIZARD_NUMERIC_CONSTANT_TITLE);
        this.setTitle(Messages._UI_WIZARD_NUMERIC_CONSTANT_HEADER);
        this.setDescription(Messages._UI_WIZARD_NUMERIC_CONSTANT_EXPL);
        this.setPageComplete(true);
        this.sqlStatement = sqlStatementArg;
        this.inputSQLExpression = sqlExpr;
    }

    public void createControl(Composite parent) {
        this.mainPanel = new Composite(parent, 0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchHelpSystem helpSystem = workbench.getHelpSystem();
        helpSystem.setHelp((Control)this.mainPanel, "org.eclipse.datatools.sqltools.sqlbuilder.sqle0700");
        GridLayout mainPanelLayout = new GridLayout();
        this.mainPanel.setLayout((Layout)mainPanelLayout);
        this.mainPanel.setLayoutData((Object)ViewUtility.createFill());
        Composite topPanel = new Composite(this.mainPanel, 0);
        GridLayout topPanelLayout = new GridLayout();
        topPanelLayout.numColumns = 2;
        topPanelLayout.marginWidth = 0;
        topPanelLayout.marginHeight = 0;
        topPanelLayout.horizontalSpacing = 0;
        topPanelLayout.makeColumnsEqualWidth = false;
        topPanel.setLayout((Layout)topPanelLayout);
        topPanel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.constantText = new Text(topPanel, 2316);
        this.constantText.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.constantText.setText(DEFAULT_TEXT);
        this.constantText.setBackground(Display.getCurrent().getSystemColor(1));
        this.constantText.setEnabled(true);
        this.constantText.setEditable(true);
        this.constantText.addListener(25, new Listener(){
            Pattern pattern = Pattern.compile("[+-]|\\.|[+-].|([+-]?((\\d+(\\.?\\d*)?)|(\\.?\\d+))([eE][+-]?\\d*)?)");

            public void handleEvent(Event e) {
                e.doit = false;
                if (e.character == '\b' || e.character == '\u007f') {
                    e.doit = true;
                } else {
                    String currentText = NumericConstantBuilderPage.this.constantText.getText();
                    StringBuffer newTextBuf = new StringBuffer(currentText);
                    char[] chars = e.text.toCharArray();
                    int index = e.start - 1;
                    int i = 0;
                    while (i < e.text.length()) {
                        if (++index >= newTextBuf.length()) {
                            newTextBuf.append(chars[i]);
                        } else {
                            newTextBuf.setCharAt(index, chars[i]);
                        }
                        ++i;
                    }
                    Matcher matcher = this.pattern.matcher(newTextBuf);
                    if (matcher.matches()) {
                        e.doit = true;
                    }
                }
            }
        });
        this.constantText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                NumericConstantBuilderPage.this.updateFinishButton();
            }
        });
        Composite functionButtonPanel = new Composite(this.mainPanel, 0);
        GridLayout functionButtonPanelLayout = new GridLayout();
        functionButtonPanelLayout.numColumns = 4;
        functionButtonPanelLayout.makeColumnsEqualWidth = true;
        functionButtonPanel.setLayout((Layout)functionButtonPanelLayout);
        functionButtonPanel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.clearButton = new Button(functionButtonPanel, 8);
        this.clearButton.setText(Messages._UI_BUTTON_CLEAR);
        this.clearButton.setLayoutData((Object)ViewUtility.createFill());
        this.clearButton.addSelectionListener((SelectionListener)this);
        this.updateFinishButton();
        this.setControl((Control)this.mainPanel);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.widget == this.clearButton) {
            this.doClear();
        }
    }

    public void setInputExpression(QueryValueExpression in) {
        this.inputSQLExpression = in;
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.constantText.setEnabled(true);
        this.constantText.setEditable(true);
        if (visible) {
            this.updateFinishButton();
            if (this.inputSQLExpression != null) {
                String input = this.inputSQLExpression.getSQL();
                this.constantText.setText(input);
                this.constantText.append("");
            }
            this.constantText.setFocus();
        }
    }

    private void updateFinishButton() {
        String text;
        boolean isComplete = false;
        Pattern pattern = Pattern.compile(REGEX_FINAL);
        Matcher matcher = pattern.matcher(text = this.constantText.getText());
        if (matcher.matches()) {
            isComplete = true;
        }
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setAllPagesComplete(isComplete);
        } else if (this.getWizard() instanceof ConstantExpressionWizard) {
            ConstantExpressionWizard wiz = (ConstantExpressionWizard)this.getWizard();
            wiz.setConstantOptionsPageComplete(isComplete);
        }
        this.setPageComplete(isComplete);
    }

    public boolean performOk() {
        QueryValueExpression sqlConstantExpr;
        String finalNumber = this.constantText.getText();
        this.updatedSQLExpression = sqlConstantExpr = ExpressionHelper.createExpression(finalNumber);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        } else if (this.getWizard() instanceof ConstantExpressionWizard) {
            ConstantExpressionWizard wiz = (ConstantExpressionWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        }
        return true;
    }

    private void doClear() {
        this.constantText.setText(DEFAULT_TEXT);
    }

    public boolean currentPage() {
        return this.isCurrentPage();
    }
}

