/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder;

import java.util.EventObject;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.IContentChangeListener;
import org.eclipse.datatools.sqltools.sqlbuilder.IExecuteSQLListener;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.ParseException;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.SQLBuilderActionBarContributor;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInputUsageOptions;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderEditorInputUsageOptions;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderFileEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ControlStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IControlStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IWindowStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.OmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.WindowStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.sqlbuilder.util.SQLParserUtil;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.WindowUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.WorkbenchUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.CustomSashForm;
import org.eclipse.datatools.sqltools.sqlbuilder.views.DesignViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.SQLTreeViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.GraphControl;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLSourceViewer;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SQLBuilder
implements IEditingDomainProvider,
Observer,
IContentChangeListener,
IMenuListener {
    protected Composite _parentControl = null;
    protected CustomSashForm _sashMain = null;
    protected CustomSashForm _sashSourceGraph = null;
    protected CustomSashForm _sashGraphOutline = null;
    protected static final int DEFAULT_SASHMAIN_WEIGHT1 = 200;
    protected static final int DEFAULT_SASHMAIN_WEIGHT2 = 100;
    protected static final int DEFAULT_SASHSOURCEGRAPH_WEIGHT1 = 100;
    protected static final int DEFAULT_SASHSOURCEGRAPH_WEIGHT2 = 100;
    protected static final int DEFAULT_SASHGRAPHOUTLINE_WEIGHT1 = 200;
    protected static final int DEFAULT_SASHGRAPHOUTLINE_WEIGHT2 = 100;
    protected static final int DEFAULT_SASHMAIN_HEIGHT = 400;
    protected static final int DEFAULT_SASHMAIN_WIDTH = 600;
    protected SQLTreeViewer _contentOutlinePage;
    protected DesignViewer _designViewer;
    protected SQLSourceViewer _sourceViewer;
    protected GraphControl _graphControl;
    protected ISQLBuilderEditorInput _sqlBuilderEditorInput = null;
    protected IWindowStateInfo _windowStateInfo = null;
    protected ISQLBuilderEditorInputUsageOptions _editorInputUsageOptions = null;
    protected IFile _iFile;
    protected ListenerList _contentChangeListeners = null;
    protected ListenerList _executeSQLListeners = null;
    protected IEditorPart _editor = null;
    protected AdapterFactoryEditingDomain _editingDomain;
    protected SQLDomainModel _sqlDomainModel;
    protected SQLBuilderActionBarContributor _actionBarContributor;
    protected Object _currentSelection;
    protected boolean _loadOnConnection = false;
    protected boolean _inputLoaded = false;
    protected boolean _clientCreated = false;
    protected boolean _inCreateClient = false;

    public SQLBuilder() {
        this(null);
    }

    public SQLBuilder(IEditorPart ed) {
        this._editor = ed;
        this._sqlDomainModel = new SQLDomainModel();
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
            }
        });
        this._editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)SQLBuilderPlugin.getAdapterFactory(), (CommandStack)commandStack);
        this._sqlDomainModel.setEditingDomain(this._editingDomain);
        this._contentChangeListeners = new ListenerList();
        this._executeSQLListeners = new ListenerList();
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        if (this._contentChangeListeners != null) {
            this._contentChangeListeners.add((Object)listener);
        }
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this._contentChangeListeners != null) {
            this._contentChangeListeners.remove((Object)listener);
        }
    }

    public void addExecuteSQLListener(IExecuteSQLListener listener) {
        if (this._executeSQLListeners != null) {
            this._executeSQLListeners.add((Object)listener);
        }
    }

    public void removeExecuteSQLListener(IExecuteSQLListener listener) {
        if (this._executeSQLListeners != null) {
            this._executeSQLListeners.remove((Object)listener);
        }
    }

    public void createClient(Composite parent) {
        IWindowStateInfo winState;
        this._inCreateClient = true;
        this._parentControl = parent;
        this._sashMain = new CustomSashForm(parent, 512, 1);
        int height = 400;
        int width = 600;
        if (this._sqlBuilderEditorInput != null && (winState = this._sqlBuilderEditorInput.getWindowStateInfo()) != null) {
            height = winState.getHeight() <= 0 ? height : winState.getHeight();
            width = winState.getWidth() <= 0 ? width : winState.getWidth();
        }
        this._sashMain.setSize(width, height);
        if (this._inputLoaded) {
            this.doCreateClient();
        }
        this._inCreateClient = false;
    }

    private void doCreateClient() {
        Composite graphComposite;
        this._sashSourceGraph = new CustomSashForm((Composite)this._sashMain, 512);
        this._sashSourceGraph.setLayoutData(ViewUtility.createFill());
        Composite outsideSrcComp = ViewUtility.createNestedComposite((Composite)this._sashSourceGraph, 0);
        Composite srcComposite = ViewUtility.createNestedComposite(outsideSrcComp, 2048);
        this.createSourceViewer(srcComposite);
        this._sashGraphOutline = null;
        if (this._editor == null) {
            this._sashGraphOutline = new CustomSashForm((Composite)this._sashSourceGraph, 256, 1);
            this._sashGraphOutline.setLayoutData(ViewUtility.createFill());
            graphComposite = ViewUtility.createNestedComposite((Composite)this._sashGraphOutline, 2048);
            this.createGraphViewer(graphComposite);
        } else {
            graphComposite = ViewUtility.createNestedComposite((Composite)this._sashSourceGraph, 0);
            this.createGraphViewer(graphComposite);
        }
        Composite designComposite = ViewUtility.createNestedComposite((Composite)this._sashMain, 2048);
        this.createDesignViewer(designComposite);
        this._sashMain.setLayoutData(ViewUtility.createFill());
        this._clientCreated = true;
        if (this._sashGraphOutline != null) {
            Composite contentOutlineComposite = ViewUtility.createNestedComposite((Composite)this._sashGraphOutline, 2048);
            this.getContentOutlinePage(contentOutlineComposite);
        } else {
            this.getContentOutlinePage((Composite)this._sashGraphOutline);
        }
        if (this.useWindowState()) {
            this.restoreWindowState();
        } else {
            this._sashMain.setWeights(new int[]{200, 100});
            this._sashSourceGraph.setWeights(new int[]{100, 100});
            if (this._sashGraphOutline != null) {
                this._sashGraphOutline.setWeights(new int[]{200, 100});
            }
        }
        ((IChangeNotifier)this.getDomainModel().getAdapterFactory()).addListener(new INotifyChangedListener(){

            public void notifyChanged(Notification msg) {
                if (Display.getCurrent() != null) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SQLBuilder.this.notifyContentChange();
                        }
                    });
                }
            }
        });
        boolean isProper = this._sqlDomainModel.isProper();
        this.updateProperStatement(isProper);
        this._graphControl.refresh();
        this._graphControl.setSQLBuilder(this);
        if (!this._inputLoaded) {
            this._sourceViewer.revertToDefaultSource();
        }
    }

    private boolean useWindowState() {
        return this._editorInputUsageOptions != null && this._windowStateInfo != null && this._editorInputUsageOptions.useWindowState();
    }

    public void setLoadOnConnection(boolean loadOnConnection) {
        this._loadOnConnection = loadOnConnection;
    }

    public void setInput(ISQLBuilderEditorInput sqlBuilderEditorInput) throws PartInitException, ParseException {
        this._sqlBuilderEditorInput = sqlBuilderEditorInput;
        if (this._sqlBuilderEditorInput != null) {
            IOmitSchemaInfo omitSchemaInfo = this._sqlBuilderEditorInput.getOmitSchemaInfo();
            this._sqlDomainModel.setOmitSchemaInfo(omitSchemaInfo);
            ((OmitSchemaInfo)omitSchemaInfo).addObserver(this);
            ISQLEditorConnectionInfo connInfo = this._sqlBuilderEditorInput.getConnectionInfo();
            this._sqlDomainModel.setConnectionInfo(connInfo);
            this._sqlDomainModel.setCurrentSchema();
            Database db = connInfo.getDatabase();
            if (db != null || !this._loadOnConnection) {
                this.loadInput();
            }
        }
    }

    protected void loadInput() throws PartInitException, ParseException {
        ISQLEditorConnectionInfo connInfo = this._sqlDomainModel.getConnectionInfo();
        Database db = null;
        if (connInfo != null) {
            db = connInfo.getDatabase();
        }
        if (db == null && connInfo != null) {
            throw new PartInitException(NLS.bind((String)Messages._EXC_OPEN_SQL_FILE_NOT_CONNECTED, (Object)connInfo.getConnectionProfileName()));
        }
        this._sqlDomainModel.setDatabase(db);
        if (this._sqlBuilderEditorInput instanceof SQLBuilderFileEditorInput) {
            SQLBuilderFileEditorInput sqlBuilderFileEditorInput = (SQLBuilderFileEditorInput)this._sqlBuilderEditorInput;
            try {
                IFile fileResource = sqlBuilderFileEditorInput.getFile();
                if (fileResource == null) {
                    throw new PartInitException(Messages._EXC_OPEN_SQL_FILE_RESOURCE);
                }
                this._inputLoaded = this._sqlDomainModel.openFileResource(fileResource);
            }
            catch (Exception exception) {
                throw new PartInitException(Messages._EXC_OPEN_SQL_FILE_RESOURCE);
            }
        } else if (this._sqlBuilderEditorInput instanceof SQLEditorStorageEditorInput) {
            SQLEditorStorageEditorInput storageEditorInput = (SQLEditorStorageEditorInput)this._sqlBuilderEditorInput;
            IStorage storageResource = storageEditorInput.getStorage();
            try {
                this._inputLoaded = this._sqlDomainModel.openStorageResource(storageResource);
            }
            catch (Exception exception) {
                throw new PartInitException(Messages._ERROR_OPEN_SQL_STORAGE_RESOURCE);
            }
        } else if (this._sqlBuilderEditorInput instanceof SQLBuilderEditorInput) {
            SQLBuilderEditorInput editorInput = (SQLBuilderEditorInput)this._sqlBuilderEditorInput;
            String strSQL = editorInput.getSQL();
            if (strSQL == null || strSQL.length() == 0) {
                int statementType = editorInput.getStatementType();
                try {
                    this._inputLoaded = this._sqlDomainModel.initializeFromType(statementType);
                }
                catch (Exception exception) {
                    throw new PartInitException(Messages._ERROR_OPEN_SQL_STRING_RESOURCE);
                }
            } else if (editorInput.getSQLStatementInfo().getSQLDialectInfo() == null) {
                try {
                    this._inputLoaded = this._sqlDomainModel.initializeFromString(strSQL, null);
                }
                catch (Exception exception) {
                    throw new PartInitException(Messages._ERROR_OPEN_SQL_STRING_RESOURCE);
                }
            } else {
                try {
                    QueryStatement sqlStatement = SQLParserUtil.parseForDifferentDialect(editorInput, this._sqlDomainModel);
                    String initialSQL = SQLParserUtil.generateSQL(sqlStatement, editorInput);
                    this._sqlDomainModel.setSQLStatement(sqlStatement);
                    this._sqlDomainModel.setInitialSource(initialSQL);
                    this._sqlDomainModel.getSqlSourceFormat();
                    String newSQL = initialSQL;
                    this._inputLoaded = this._sqlDomainModel.initializeFromString(newSQL, null);
                }
                catch (Exception exception) {
                    throw new PartInitException(Messages._ERROR_OPEN_SQL_STRING_RESOURCE);
                }
            }
        } else {
            throw new PartInitException(Messages._ERROR_INPUT_NOT_RECOGNIZED);
        }
        this._windowStateInfo = this._sqlBuilderEditorInput.getWindowStateInfo();
        this._editorInputUsageOptions = this._sqlBuilderEditorInput.getInputUsageOptions();
        if (!this._inputLoaded) {
            this._inputLoaded = true;
            if (this._sqlDomainModel.isUnmatchedSource()) {
                throw new ParseException(Messages._ERROR_OPEN_INPUT_PARSE_FAILED);
            }
        }
    }

    public void saveOmitSchemaInfo(IFile file) {
        if (file != null) {
            SQLFileUtil.setEncodedOmitSchemaInfo(file, this.getOmitSchemaInfo().encode());
        }
    }

    protected void createSourceViewer(Composite client) {
        this._sourceViewer = new SQLSourceViewer(this._sqlDomainModel, client, true);
        this._sourceViewer.setContentChangeListener(this);
        this._sourceViewer.initDBContext();
        this._sourceViewer.setContentProvider((IContentProvider)this._sqlDomainModel.createContentProvider());
        this._sourceViewer.setSQLBuilder(this);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this._sourceViewer.getControl().getParent().setLayoutData((Object)data);
    }

    protected void createGraphViewer(Composite client) {
        this._graphControl = new GraphControl(this._sqlDomainModel);
        this._graphControl.createControl(client);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this._graphControl.getControl().setLayoutData((Object)data);
    }

    protected void createDesignViewer(Composite client) {
        this._designViewer = new DesignViewer(this._sqlDomainModel, client);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this._designViewer.setLayoutData(data);
    }

    public SQLSourceViewer getSourceViewer() {
        return this._sourceViewer;
    }

    public GraphControl getGraphViewer() {
        return this._graphControl;
    }

    public DesignViewer getDesignViewer() {
        return this._designViewer;
    }

    public SQLTreeViewer getSQLTreeViewer() {
        return this._contentOutlinePage;
    }

    public IContentOutlinePage getContentOutlinePage(Composite composite) {
        if (this._clientCreated && this._contentOutlinePage == null) {
            QueryStatement sqlStatement = this._sqlDomainModel.getSQLStatement();
            this._contentOutlinePage = new SQLTreeViewer(this, (IContentProvider)this._sqlDomainModel.createContentProvider(), (ILabelProvider)this._sqlDomainModel.createLabelProvider(), sqlStatement);
            if (composite != null) {
                this._contentOutlinePage.createControl(composite);
                GridData data = new GridData();
                data.verticalAlignment = 4;
                data.horizontalAlignment = 4;
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = true;
                this._contentOutlinePage.getControl().setLayoutData((Object)data);
            }
            this._contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SQLBuilder.this.handleContentOutlineSelection(event.getSelection(), true);
                }
            });
            this.handleContentOutlineSelection((ISelection)new StructuredSelection((Object)sqlStatement), false);
        }
        return this._contentOutlinePage;
    }

    public void handleContentOutlineSelection(ISelection selection, boolean fromEvent) {
        this._currentSelection = WindowUtility.getSelection(selection);
        if (this._currentSelection != null) {
            this._graphControl.setInput(this._currentSelection);
            this._designViewer.inputChanged(this._currentSelection);
            this._sourceViewer.setInput(this._currentSelection);
            if (this._currentSelection instanceof WithTableSpecification || this._currentSelection instanceof QueryCombined || this._currentSelection instanceof QueryValues) {
                this.setGraphControlState(false);
                this._sashSourceGraph.layout(true);
            } else if (this._currentSelection instanceof QuerySelect) {
                this.setGraphControlState(true);
                this._sashSourceGraph.layout(true);
            } else if (this._currentSelection instanceof QuerySelectStatement || this._currentSelection instanceof QueryExpressionRoot) {
                QueryExpressionBody queryBody = null;
                if (this._currentSelection instanceof QuerySelectStatement) {
                    queryBody = SelectHelper.getQueryExpressionBody((QuerySelectStatement)this._currentSelection);
                } else if (this._currentSelection instanceof QueryExpressionRoot) {
                    QueryExpressionRoot qRoot = (QueryExpressionRoot)this._currentSelection;
                    queryBody = SelectHelper.getQueryExpressionBody(qRoot.getSelectStatement());
                }
                if (queryBody instanceof QuerySelect) {
                    this.setGraphControlState(true);
                    this._sashSourceGraph.layout(true);
                } else if (queryBody instanceof QueryCombined) {
                    this.setGraphControlState(false);
                    this._sashSourceGraph.layout(true);
                } else if (queryBody instanceof QueryValues) {
                    this.setGraphControlState(false);
                    this._sashSourceGraph.layout(true);
                } else {
                    this.setGraphControlState(true);
                    this._sashSourceGraph.layout(true);
                }
            }
        }
    }

    private void setGraphControlState(boolean state) {
        if (this._editor != null) {
            this._graphControl.getControl().setVisible(state);
        } else {
            this._graphControl.getControl().setEnabled(state);
        }
    }

    public boolean isContentOutlineRootSelected() {
        return this._contentOutlinePage.isOnlyRootSelected();
    }

    public void changeStatementType(int statementType) {
        if (statementType != StatementHelper.getStatementType((QueryStatement)this._sqlDomainModel.getSQLStatement())) {
            if (!this._graphControl.getControl().isVisible()) {
                this._graphControl.getControl().setVisible(true);
                this._sashGraphOutline.layout(true);
            }
            if (!this._graphControl.getControl().isEnabled()) {
                this._graphControl.getControl().setEnabled(true);
                this._sashGraphOutline.layout(true);
            }
            this._sqlDomainModel.initializeFromType(statementType);
            this._sqlDomainModel.clearStatementToTemplate();
            this.getSQLTreeViewer().resetInput(this._sqlDomainModel.getSQLStatement());
            this.handleContentOutlineSelection((ISelection)new StructuredSelection((Object)this._sqlDomainModel.getSQLStatement()), false);
        }
    }

    public void updateProperStatement(boolean isValid) {
        this.changeGraphControlEnableState(isValid);
        this._designViewer.setEnabled(isValid);
        if (isValid && this._contentOutlinePage.getControl() != null) {
            this._contentOutlinePage.getControl().setEnabled(true);
            this._contentOutlinePage.refreshTree();
        }
    }

    public static boolean isStatementProper(SQLDomainModel domainModel) {
        return domainModel.isProper();
    }

    protected void changeGraphControlEnableState(boolean enable) {
        this._graphControl.setEnabled(enable);
        if (!enable && !this._inCreateClient) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages._UI_VALIDATE_FAILED_TITLE, (String)Messages._UI_GRAPH_PARSE_FAILED);
        }
    }

    public void reparseIfRequired() {
        if (this._sourceViewer.isTextChanged()) {
            this._sourceViewer.reparse();
        }
    }

    public void reloadFromModel() {
        this._sourceViewer.refreshSource();
    }

    public EditingDomain getEditingDomain() {
        return this._editingDomain;
    }

    protected IDocumentProvider getDocumentProvider() {
        return this.getSourceViewer().getDocumentProvider();
    }

    @Override
    public void update(Observable ob, Object arg) {
        if (ob instanceof IOmitSchemaInfo) {
            this._sqlDomainModel.setCurrentSchema();
            this.setDirty(true);
            this._sourceViewer.refreshSource(this._sqlDomainModel.getSQLStatement().getSQL());
            this.notifyContentChange();
        }
    }

    public SQLDomainModel getDomainModel() {
        return this._sqlDomainModel;
    }

    public ISQLBuilderEditorInput getSQLBuilderEditorInput() {
        return this._sqlBuilderEditorInput;
    }

    public ISQLBuilderEditorInputUsageOptions getEditorInputUsageOptions() {
        if (this._editorInputUsageOptions == null) {
            this._editorInputUsageOptions = new SQLBuilderEditorInputUsageOptions(true);
        }
        return this._editorInputUsageOptions;
    }

    public IFile getFile() {
        return this._iFile;
    }

    public boolean inValidateEditCall() {
        return false;
    }

    public SQLBuilderActionBarContributor getActionBarContributor() {
        if (this._actionBarContributor == null) {
            this._actionBarContributor = new SQLBuilderActionBarContributor();
            this._actionBarContributor.setActiveSQLBuilder(this);
        }
        return this._actionBarContributor;
    }

    public void setActionBarContributor(SQLBuilderActionBarContributor contributor) {
        this._actionBarContributor = contributor;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (progressMonitor == null || !progressMonitor.isCanceled()) {
            boolean result = true;
            if (progressMonitor != null) {
                progressMonitor.setTaskName(Messages._UI_SAVING_STATEMENT);
            }
            this._sqlDomainModel.setEditorText(this._sourceViewer.getText());
            result = this._sqlDomainModel.save();
            if (!result) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                this.notifyContentChange();
            } else {
                if (this._sqlBuilderEditorInput != null && this._sqlBuilderEditorInput instanceof SQLBuilderFileEditorInput && this._sqlDomainModel.getIFile() != null) {
                    SQLBuilderFileEditorInput sQLBuilderFileEditorInput = (SQLBuilderFileEditorInput)this._sqlBuilderEditorInput;
                    SQLFileUtil.setEncodedOmitSchemaInfo(sQLBuilderFileEditorInput.getFile(), sQLBuilderFileEditorInput.getOmitSchemaInfo().encode());
                    sQLBuilderFileEditorInput.setWindowStateInfo(this.getWindowStateInfo());
                }
                this.setDirty(false);
                if (this._sourceViewer != null) {
                    this._sourceViewer.setTextChanged(false);
                }
            }
            if (progressMonitor != null && !progressMonitor.isCanceled()) {
                WorkbenchUtility.refreshLocalWorkspaceFile(this.getFile(), progressMonitor);
            }
            this.notifyContentChange();
        }
    }

    public boolean isDirty() {
        return this._sqlDomainModel.isDirty();
    }

    public void setDirty(boolean dirty) {
        this._sqlDomainModel.setDirty(dirty);
    }

    private void restoreWindowState() {
        IControlStateInfo designViewerState;
        IControlStateInfo outlineViewerState;
        IControlStateInfo graphViewerState;
        int sourceViewerHeight = -1;
        int graphControlWidth = -1;
        int graphControlHeight = -1;
        int outlineViewerWidth = -1;
        int designViewerHeight = -1;
        IWindowStateInfo windowStateInfo = this._sqlBuilderEditorInput.getWindowStateInfo();
        if (windowStateInfo == null) {
            return;
        }
        IControlStateInfo sourceViewerState = windowStateInfo.get(1);
        if (sourceViewerState != null) {
            sourceViewerHeight = sourceViewerState.getHeight();
        }
        if ((graphViewerState = windowStateInfo.get(2)) != null) {
            graphControlWidth = graphViewerState.getWidth();
            graphControlHeight = graphViewerState.getHeight();
        }
        if ((outlineViewerState = windowStateInfo.get(3)) != null) {
            outlineViewerWidth = outlineViewerState.getWidth();
        }
        if ((designViewerState = windowStateInfo.get(4)) != null) {
            designViewerHeight = designViewerState.getHeight();
        }
        if (sourceViewerHeight != -1 && graphControlHeight != -1 && designViewerHeight != -1) {
            this._sashMain.setWeights(new int[]{sourceViewerHeight + graphControlHeight, designViewerHeight});
        } else {
            this._sashMain.setWeights(new int[]{200, 100});
        }
        if (sourceViewerHeight != -1 && graphControlHeight != -1) {
            this._sashSourceGraph.setWeights(new int[]{sourceViewerHeight, graphControlHeight});
        } else {
            this._sashSourceGraph.setWeights(new int[]{100, 100});
        }
        if (this._sashGraphOutline != null) {
            if (graphControlWidth != -1 && outlineViewerWidth != -1) {
                this._sashGraphOutline.setWeights(new int[]{graphControlWidth, outlineViewerWidth});
            } else {
                this._sashGraphOutline.setWeights(new int[]{200, 100});
            }
        }
        if (designViewerState != null && !designViewerState.isVisible()) {
            this.hideDown(this._sashMain);
        }
        if (sourceViewerState != null && !sourceViewerState.isVisible()) {
            this.hideUp(this._sashSourceGraph);
        } else if (graphViewerState != null && !graphViewerState.isVisible()) {
            if (this._sashGraphOutline == null) {
                this.hideDown(this._sashSourceGraph);
            } else if (outlineViewerState != null && !outlineViewerState.isVisible()) {
                this.hideDown(this._sashSourceGraph);
            }
        }
        if (this._sashGraphOutline != null && (graphViewerState == null || graphViewerState.isVisible() || outlineViewerState == null || outlineViewerState.isVisible())) {
            if (graphViewerState != null && !graphViewerState.isVisible()) {
                this.hideLeft(this._sashGraphOutline);
            } else if (outlineViewerState != null && !outlineViewerState.isVisible()) {
                this.hideRight(this._sashGraphOutline);
            }
        }
        if (designViewerState != null && !designViewerState.isHideable()) {
            this._sashMain.setNoHideDown(true);
        }
        if (sourceViewerState != null && !sourceViewerState.isHideable()) {
            this._sashSourceGraph.setNoHideUp(true);
        }
        if (graphViewerState != null && !graphViewerState.isHideable()) {
            this._sashSourceGraph.setNoHideDown(true);
        }
        if (this._sashGraphOutline != null && outlineViewerState != null && !outlineViewerState.isHideable()) {
            this._sashGraphOutline.setNoHideRight(true);
        }
    }

    private void hideUp(CustomSashForm sashForm) {
        boolean tmpNoHideUp = sashForm.isNoHideUp();
        sashForm.setNoHideUp(false);
        sashForm.hideUp();
        sashForm.setNoHideUp(tmpNoHideUp);
    }

    private void hideLeft(CustomSashForm sashForm) {
        this.hideUp(sashForm);
    }

    private void hideDown(CustomSashForm sashForm) {
        boolean tmpNoHideDown = sashForm.isNoHideDown();
        sashForm.setNoHideDown(false);
        sashForm.hideDown();
        sashForm.setNoHideDown(tmpNoHideDown);
    }

    private void hideRight(CustomSashForm sashForm) {
        this.hideDown(sashForm);
    }

    public IWindowStateInfo getWindowStateInfo() {
        if (this._windowStateInfo == null) {
            this._windowStateInfo = new WindowStateInfo();
        }
        this.saveWindowStateInfo();
        return this._windowStateInfo;
    }

    private void saveWindowStateInfo() {
        this._windowStateInfo.setHeight(this._parentControl.getSize().y);
        this._windowStateInfo.setWidth(this._parentControl.getSize().x);
        IControlStateInfo sourceState = this.getControlState(this._windowStateInfo, 1);
        this.setControlStateSize(sourceState, this.getSourceViewer().getControl(), this._sashSourceGraph, 0);
        sourceState.setIsHideable(!this._sashSourceGraph.isNoHideUp());
        sourceState.setIsVisible(this._sashSourceGraph.getWeights()[0] != 0);
        IControlStateInfo graphicalState = this.getControlState(this._windowStateInfo, 2);
        this.setControlStateSize(graphicalState, this.getGraphViewer().getControl(), this._sashSourceGraph, 1);
        graphicalState.setIsHideable(!this._sashSourceGraph.isNoHideDown());
        graphicalState.setIsVisible(this._sashSourceGraph.getWeights()[1] != 0);
        if (this._editor != null) {
            this._windowStateInfo.remove(3);
        } else {
            IControlStateInfo outlineState = this.getControlState(this._windowStateInfo, 3);
            this.setControlStateSize(outlineState, this.getSQLTreeViewer().getControl(), this._sashGraphOutline, 1);
            outlineState.setIsHideable(!this._sashGraphOutline.isNoHideRight());
            outlineState.setIsVisible(this._sashGraphOutline.getWeights()[1] != 0);
        }
        IControlStateInfo designState = this.getControlState(this._windowStateInfo, 4);
        this.setControlStateSize(designState, (Control)this.getDesignViewer(), this._sashMain, 1);
        designState.setIsHideable(!this._sashMain.isNoHideDown());
        designState.setIsVisible(this._sashMain.getWeights()[1] != 0);
    }

    private IControlStateInfo getControlState(IWindowStateInfo windowStateInfo, int controlType) {
        IControlStateInfo state = windowStateInfo.get(controlType);
        if (state == null) {
            state = new ControlStateInfo();
            this._windowStateInfo.put(controlType, state);
        }
        return state;
    }

    private void setControlStateSize(IControlStateInfo stateInfo, Control control, CustomSashForm sashForm, int iSashIndex) {
        Point size = control.getSize();
        int[] weights = sashForm.getWeights();
        if (weights[0] != 0 && weights[1] != 0) {
            stateInfo.setWidth(size.x);
            stateInfo.setHeight(size.y);
            return;
        }
        if (sashForm.getOrientation() == 512) {
            stateInfo.setWidth(size.x);
            if (sashForm.getSavedSizes() != null && sashForm.getSavedSizes().length > iSashIndex && sashForm.getSavedSizes()[iSashIndex] != null) {
                stateInfo.setHeight(sashForm.getSavedSizes()[iSashIndex].y);
            } else {
                stateInfo.setHeight(100);
            }
        } else if (sashForm.getOrientation() == 256) {
            if (sashForm.getSavedSizes() != null && sashForm.getSavedSizes().length > iSashIndex && sashForm.getSavedSizes()[iSashIndex] != null) {
                stateInfo.setWidth(sashForm.getSavedSizes()[iSashIndex].x);
            } else {
                stateInfo.setWidth(200);
            }
            stateInfo.setHeight(size.y);
        }
    }

    protected boolean validateBeforeSave() {
        return SQLBuilderPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.datatools.sqltools.sqlbuilder.P_VALIDATE_BEFORE_SAVE");
    }

    @Override
    public void notifyContentChange() {
        Object[] listeners = this._contentChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IContentChangeListener)listeners[i]).notifyContentChange();
            ++i;
        }
    }

    public void notifySQLExecuted() {
        Object[] listeners = this._executeSQLListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IExecuteSQLListener)listeners[i]).executedSQL();
            ++i;
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("edit"));
        this._contentOutlinePage.fillContextMenu();
        if (this.getActionBarContributor() != null) {
            IAction revertToPreviousAction;
            boolean enableRevert = !SQLBuilder.isStatementProper(this.getDomainModel());
            IAction revertToDefaultAction = this._actionBarContributor.getAction("RevertToDefaultAction");
            if (revertToDefaultAction != null) {
                revertToDefaultAction.setEnabled(enableRevert);
            }
            if ((revertToPreviousAction = this._actionBarContributor.getAction("RevertToPreviousAction")) != null) {
                revertToPreviousAction.setEnabled(enableRevert);
            }
            IAction changeStatementTypeAction = this._actionBarContributor.getAction("ChangeStatementType");
            changeStatementTypeAction.setEnabled(true);
            IAction omitCurrentSchemaAction = this._actionBarContributor.getAction("OmitCurrentSchema");
            if (omitCurrentSchemaAction != null) {
                boolean enableOmitCurrentSchema = false;
                enableOmitCurrentSchema = this.getDomainModel() != null && this.getDomainModel().getDatabaseDefinition() != null ? this.getDomainModel().getDatabaseDefinition().supportsSchema() : false;
                omitCurrentSchemaAction.setEnabled(enableOmitCurrentSchema);
            }
        }
    }

    public MenuManager createContextMenuFor(Viewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        if (this._editor != null) {
            this._editor.getEditorSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
        }
        return contextMenu;
    }

    public String getSQL() {
        return this._sqlDomainModel.getSQLStatement().getSQL();
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this._sqlDomainModel.getConnectionInfo();
    }

    public IOmitSchemaInfo getOmitSchemaInfo() {
        return this._sqlDomainModel.getOmitSchemaInfo();
    }

    public void connectIfNeeded(IWorkbenchPart part) {
        Database db = this._sqlDomainModel.getDatabase();
        if (db == null) {
            IWorkbenchPage activePage;
            boolean keepTrying = true;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
            if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null && activePage.isPartVisible(part)) {
                keepTrying = false;
                ISQLEditorConnectionInfo connInfo = this._sqlDomainModel.getConnectionInfo();
                if (connInfo != null && (db = connInfo.getDatabase()) != null) {
                    try {
                        this.loadInput();
                        this.doCreateClient();
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (db == null && keepTrying) {
                ConnectRunnable connectRunnable = new ConnectRunnable(part, this);
                Display display = workbench.getDisplay();
                int delayTime = 1000;
                display.timerExec(delayTime, (Runnable)connectRunnable);
            }
        }
    }

    class ConnectRunnable
    implements Runnable {
        SQLBuilder _sqlBuilder;
        IWorkbenchPart _part;

        public ConnectRunnable(IWorkbenchPart part, SQLBuilder sqlBuilder) {
            this._part = part;
            this._sqlBuilder = sqlBuilder;
        }

        @Override
        public void run() {
            this._sqlBuilder.connectIfNeeded(this._part);
        }
    }
}

