/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.catalog.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.enablement.mysql.model.impl.MySqlUserImpl;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;

public class MySqlAuthorizationIdentifierLoader
extends JDBCBaseLoader {
    private static final String USER_QUERY = "SELECT * FROM mysql.user;";
    private static final String USER_NAME = "User";
    private static final String HOST_NAME = "Host";

    public MySqlAuthorizationIdentifierLoader() {
        this(null);
    }

    public MySqlAuthorizationIdentifierLoader(ICatalogObject catalogObject) {
        this(catalogObject, (IConnectionFilterProvider)new SchemaObjectFilterProvider("DatatoolsSequenceFilterPredicate"));
    }

    public MySqlAuthorizationIdentifierLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void clearAuthorizationIdentifiers(List existingAuthorizationIds) {
        existingAuthorizationIds.clear();
    }

    public void loadAuthorizationIdentifiers(List containmentList, List existingAuthorizationIds) throws SQLException {
        block35: {
            ResultSet rs = null;
            PreparedStatement stmt = null;
            try {
                stmt = this.getCatalogObject().getConnection().prepareStatement(USER_QUERY);
                rs = this.createResultSet(stmt);
                while (rs.next()) {
                    String userDisplayName = this.toDisplayLabel(rs);
                    if (userDisplayName == null || this.isFiltered(userDisplayName)) continue;
                    User user = (User)this.getAndRemoveSQLObject(existingAuthorizationIds, userDisplayName);
                    if (user == null) {
                        user = this.processRow(rs);
                        if (user == null) continue;
                        containmentList.add(user);
                        continue;
                    }
                    containmentList.add(user);
                    if (!(user instanceof ICatalogObject)) continue;
                    ((ICatalogObject)user).refresh();
                }
            }
            catch (Throwable throwable) {
                block33: {
                    try {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                                break block33;
                            }
                            catch (SQLException sQLException2) {}
                            break block33;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                        throw throwable2;
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            try {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block35;
                    }
                    catch (SQLException sQLException3) {}
                    break block35;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected String toDisplayLabel(ResultSet rs) throws SQLException {
        String userName = rs.getString(USER_NAME).trim();
        String hostName = rs.getString(HOST_NAME).trim();
        String displayName = String.valueOf(userName) + " [" + hostName + ']';
        return displayName;
    }

    protected User processRow(ResultSet rs) throws SQLException {
        MySqlUserImpl user = new MySqlUserImpl();
        String displayName = this.toDisplayLabel(rs);
        user.setName(displayName);
        user.setLabel(displayName);
        return user;
    }

    protected ResultSet createResultSet(PreparedStatement stmt) throws SQLException {
        try {
            return stmt.executeQuery();
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException("Error while retrieving database information (authorization identifiers)");
            error.initCause(e);
            throw error;
        }
    }
}

