/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.signature.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.signature.comments.InterfaceEventComment;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignatureDefinition;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignaturePackage;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.signature.utilities.InterfaceUtilities;
import org.eclipse.comma.signature.validation.AbstractInterfaceSignatureValidator;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class InterfaceSignatureValidator
extends AbstractInterfaceSignatureValidator {
    @Inject
    private IEObjectDocumentationProvider documentationProvider;

    @Check
    public void checkNamesImportedTypeModels(InterfaceSignatureDefinition root) {
        String sigFilename = root.eResource().getURI().trimFileExtension().lastSegment();
        Iterable _filter = Iterables.filter((Iterable)root.getImports(), FileImport.class);
        for (FileImport import_ : _filter) {
            String importedFilename = URI.createURI((String)import_.getImportURI()).trimFileExtension().lastSegment();
            boolean _equals = importedFilename.equals(sigFilename);
            if (!_equals) continue;
            this.error("Imported type file should have a different name than the current signature file.", (EObject)import_, (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
        }
    }

    @Check
    public void checkDuplicatedTypeNamesInInterface(Signature s) {
        this.checkForNameDuplications((Iterable)s.getTypes(), "type declaration", null, new String[0]);
    }

    @Check
    public void checkTypesForDuplications(InterfaceSignatureDefinition decl) {
        Multimap multiMap = this.getImportedTypes(decl);
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported type " + _string;
            this.error(_plus, (EObject)decl.getSignature(), (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
        List<InterfaceEvent> events = InterfaceUtilities.getAllInterfaceEvents(decl.getSignature());
        Functions.Function1<QualifiedName, String> _function = new Functions.Function1<QualifiedName, String>(){

            public String apply(QualifiedName it) {
                return it.getLastSegment();
            }
        };
        Set simpleTypeNames = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)multiMap.keySet(), (Functions.Function1)_function));
        for (InterfaceEvent ev : events) {
            boolean _contains = simpleTypeNames.contains(ev.getName());
            if (!_contains) continue;
            this.error("Interface event duplicates type name", (EObject)ev, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkDuplicatedParameters(InterfaceEvent e) {
        this.checkForNameDuplications((Iterable)e.getParameters(), "parameter", null, new String[0]);
    }

    @Check
    public void checkParameterDirection(InterfaceEvent e) {
        if (e instanceof Notification || e instanceof Signal) {
            EList<Parameter> _parameters = e.getParameters();
            for (Parameter p : _parameters) {
                boolean _notEquals;
                DIRECTION _direction = p.getDirection();
                boolean bl = _notEquals = !Objects.equal((Object)((Object)_direction), (Object)((Object)DIRECTION.IN));
                if (!_notEquals) continue;
                this.error("Direction of parameters in notifications and signals must be IN", (EStructuralFeature)InterfaceSignaturePackage.Literals.INTERFACE_EVENT__PARAMETERS, e.getParameters().indexOf((Object)p));
            }
        }
    }

    @Check
    public void checkDuplicatedInterfaceEvents(Signature s) {
        this.checkForNameDuplications(InterfaceUtilities.getAllInterfaceEvents(s), "interface event", null, new String[0]);
    }

    @Check
    public void checkComment(InterfaceEvent ev) {
        boolean _not;
        String _documentation = this.documentationProvider.getDocumentation((EObject)ev);
        InterfaceEventComment evComment = new InterfaceEventComment(ev, _documentation);
        boolean _isValid = evComment.isValid();
        boolean bl = _not = !_isValid;
        if (_not) {
            this.warning(evComment.getErrorMessage(), (EObject)ev, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkForVoidType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("void")) {
            boolean _not;
            EObject _eContainer = t.eContainer();
            boolean bl = _not = !(_eContainer instanceof Command);
            if (_not) {
                this.error("Usage of type void is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
            }
        }
    }
}

