/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPart;
import org.eclipse.comma.behavior.component.component.Connection;
import org.eclipse.comma.behavior.component.component.PortReference;
import org.eclipse.comma.monitoring.lib.CEntryPoint;
import org.eclipse.comma.monitoring.lib.CPartDescriptor;
import org.eclipse.comma.monitoring.lib.CPortInstance;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class GeneratorUtility {
    public static List<List<CPortInstance>> getPortPaths(Component c) {
        ArrayList<List<CPortInstance>> _xblockexpression = null;
        ArrayList<List<CPortInstance>> result = new ArrayList<List<CPortInstance>>();
        EList _parts = c.getParts();
        for (final ComponentPart part : _parts) {
            List<List<CPortInstance>> partPaths = GeneratorUtility.getPortPaths(part.getComponentType());
            for (List<CPortInstance> path : partPaths) {
                Consumer<CPortInstance> _function = new Consumer<CPortInstance>(){

                    @Override
                    public void accept(CPortInstance it) {
                        String _plus_1;
                        String _name = part.getName();
                        String _plus = "." + _name;
                        it.componentInstance = _plus_1 = String.valueOf(_plus) + it.componentInstance;
                    }
                };
                path.forEach(_function);
            }
            result.addAll(partPaths);
        }
        EList _ports = c.getPorts();
        for (Port port : _ports) {
            PortReference connectedPort = GeneratorUtility.getConnectedPort(port, c);
            if (connectedPort == null) {
                ArrayList<CPortInstance> newPath = new ArrayList<CPortInstance>();
                String _name = port.getName();
                CPortInstance _cPortInstance = new CPortInstance("", _name);
                newPath.add(_cPortInstance);
                result.add(newPath);
                continue;
            }
            EcoreUtil.resolveAll((EObject)connectedPort);
            for (List<CPortInstance> path : result) {
                if (!path.get((int)0).componentInstance.startsWith("." + connectedPort.getPart().getName()) || !path.get((int)0).port.equals(connectedPort.getPort().getName())) continue;
                ListExtensions.reverse(path);
                String _name_1 = port.getName();
                CPortInstance _cPortInstance_1 = new CPortInstance("", _name_1);
                path.add(_cPortInstance_1);
                ListExtensions.reverse(path);
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static PortReference getConnectedPort(Port port, Component c) {
        EList _connections = c.getConnections();
        for (Connection connection : _connections) {
            if (connection.getFirstEnd().getPart() == null && connection.getFirstEnd().getPort() == port) {
                return connection.getSecondEnd();
            }
            if (connection.getSecondEnd().getPart() != null || connection.getSecondEnd().getPort() != port) continue;
            return connection.getFirstEnd();
        }
        return null;
    }

    public static List<CPartDescriptor> getPartDescriptors(Component c) {
        ArrayList<CPartDescriptor> _xblockexpression = null;
        ArrayList<CPartDescriptor> result = new ArrayList<CPartDescriptor>();
        EList _parts = c.getParts();
        for (final ComponentPart part : _parts) {
            String _name = part.getName();
            String _plus = "." + _name;
            String _name_1 = part.getComponentType().getName();
            CPartDescriptor _cPartDescriptor = new CPartDescriptor(_plus, _name_1);
            result.add(_cPartDescriptor);
            List<CPartDescriptor> subParts = GeneratorUtility.getPartDescriptors(part.getComponentType());
            Consumer<CPartDescriptor> _function = new Consumer<CPartDescriptor>(){

                @Override
                public void accept(CPartDescriptor it) {
                    String _plus_1;
                    String _name = part.getName();
                    String _plus = "." + _name;
                    it.partId = _plus_1 = String.valueOf(_plus) + it.partId;
                }
            };
            subParts.forEach(_function);
            result.addAll(subParts);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static List<CEntryPoint> getEntryPoints(Map<String, Component> instances, List<String> monitoredInstances) {
        ArrayList<CEntryPoint> _xblockexpression = null;
        ArrayList<CEntryPoint> result = new ArrayList<CEntryPoint>();
        for (String instance : monitoredInstances) {
            EList _ports = instances.get(instance).getPorts();
            for (Port port : _ports) {
                CEntryPoint entry = GeneratorUtility.getEntryPoint(instances, instance, port);
                entry.actualComponentInstance = instance;
                entry.actualPort = port.getName();
                result.add(entry);
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static CEntryPoint getEntryPoint(Map<String, Component> instances, String instance, Port port) {
        boolean _not;
        CEntryPoint _xblockexpression = null;
        boolean _contains = instance.contains(".");
        boolean bl = _not = !_contains;
        if (_not) {
            String _name = port.getName();
            return new CEntryPoint(instance, _name, "", "");
        }
        int dotIndex = instance.lastIndexOf(".");
        String parent = instance.substring(0, dotIndex);
        String part = instance.substring(dotIndex + 1);
        Component parentType = instances.get(parent);
        EList _connections = parentType.getConnections();
        for (Connection connection : _connections) {
            boolean _tripleEquals_1;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            ComponentPart _part = connection.getFirstEnd().getPart();
            boolean bl2 = _tripleNotEquals = _part != null;
            if (_tripleNotEquals && connection.getFirstEnd().getPart().getName().equals(part) && connection.getFirstEnd().getPort().getName().equals(port.getName())) {
                boolean _tripleEquals;
                ComponentPart _part_1 = connection.getSecondEnd().getPart();
                boolean bl3 = _tripleEquals = _part_1 == null;
                if (_tripleEquals) {
                    return GeneratorUtility.getEntryPoint(instances, parent, connection.getSecondEnd().getPort());
                }
                String _name_1 = port.getName();
                return new CEntryPoint(instance, _name_1, "", "");
            }
            ComponentPart _part_2 = connection.getSecondEnd().getPart();
            boolean bl4 = _tripleNotEquals_1 = _part_2 != null;
            if (!_tripleNotEquals_1 || !connection.getSecondEnd().getPart().getName().equals(part) || !connection.getSecondEnd().getPort().getName().equals(port.getName())) continue;
            ComponentPart _part_3 = connection.getFirstEnd().getPart();
            boolean bl5 = _tripleEquals_1 = _part_3 == null;
            if (_tripleEquals_1) {
                return GeneratorUtility.getEntryPoint(instances, parent, connection.getFirstEnd().getPort());
            }
            String _name_2 = port.getName();
            return new CEntryPoint(instance, _name_2, "", "");
        }
        String _name_1 = port.getName();
        _xblockexpression = new CEntryPoint(instance, _name_1, "", "");
        return _xblockexpression;
    }
}

