/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;

public class CommaFileSystemAccess
implements IFileSystemAccess {
    public static final String STATISTICS_FOLDER = "statistics";
    public static final String FOLDER_UP = "../";
    private final IFileSystemAccess2 fileSystemAccess;
    public String outputConfiguration = "DEFAULT_OUTPUT";
    private String generationFolder;
    public static final String COMMA_OUTPUT_ID = "outputCommaGen";
    public static final String COMMA_OUTPUT_FOLDER = "./comma-gen";
    public static final OutputConfiguration COMMA_OUTPUT_CONF = new Functions.Function0<OutputConfiguration>(){

        public OutputConfiguration apply() {
            OutputConfiguration config = new OutputConfiguration(CommaFileSystemAccess.COMMA_OUTPUT_ID);
            config.setOutputDirectory(CommaFileSystemAccess.COMMA_OUTPUT_FOLDER);
            config.setDescription(CommaFileSystemAccess.COMMA_OUTPUT_FOLDER);
            config.setCreateOutputDirectory(true);
            config.setCanClearOutputDirectory(true);
            config.setCleanUpDerivedResources(true);
            return config;
        }
    }.apply();

    public CommaFileSystemAccess(String generationFolder, IFileSystemAccess2 fsa) {
        this.fileSystemAccess = fsa;
        this.generationFolder = generationFolder;
    }

    public CommaFileSystemAccess(String generationFolder, CommaFileSystemAccess commaFileSystemAccess) {
        String _plus;
        this.fileSystemAccess = commaFileSystemAccess.getIFileSystemAccess();
        String _generationFolder = commaFileSystemAccess.getGenerationFolder();
        this.generationFolder = _plus = String.valueOf(_generationFolder) + generationFolder;
    }

    public CommaFileSystemAccess(IFileSystemAccess2 fsa) {
        this.fileSystemAccess = fsa;
        this.generationFolder = "";
    }

    public CommaFileSystemAccess(String generationFolder, IFileSystemAccess2 fsa, boolean commaGen) {
        this.fileSystemAccess = fsa;
        this.generationFolder = generationFolder;
        if (commaGen) {
            this.setOutPutCommaGen();
        }
    }

    public void deleteFile(String fileName) {
        this.fileSystemAccess.deleteFile(String.valueOf(this.generationFolder) + fileName, this.outputConfiguration);
    }

    public void generateFile(String fileName, CharSequence contents) {
        this.generateFile(fileName, this.outputConfiguration, contents);
    }

    public void generateFile(String fileName, String outputConfigurationName, CharSequence contents) {
        this.fileSystemAccess.generateFile(String.valueOf(this.generationFolder) + fileName, outputConfigurationName, contents);
    }

    public String generateFileLocation(String fileName, CharSequence contents) {
        this.generateFile(fileName, contents);
        return String.valueOf(this.generationFolder) + fileName;
    }

    public IFileSystemAccess2 getIFileSystemAccess() {
        return this.fileSystemAccess;
    }

    public String getGenerationFolder() {
        return this.generationFolder;
    }

    public CommaFileSystemAccess addFolder(String additionalFolder) {
        CommaFileSystemAccess _xblockexpression = null;
        String _xifexpression = null;
        boolean _endsWith = additionalFolder.endsWith("/");
        boolean _not = !_endsWith;
        _xifexpression = _not ? String.valueOf(additionalFolder) + "/" : additionalFolder;
        String path = _xifexpression;
        _xblockexpression = new CommaFileSystemAccess(path, this);
        return _xblockexpression;
    }

    public String getRootPrefix() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ((List)Conversions.doWrapArray((Object)URI.createFileURI((String)this.generationFolder).segments())).size() - 1) {
            sb.append(FOLDER_UP);
            ++i;
        }
        return sb.toString();
    }

    public String setOutPutCommaGen() {
        String _xifexpression = null;
        if (this.fileSystemAccess instanceof AbstractFileSystemAccess) {
            boolean _not;
            this.outputConfiguration = COMMA_OUTPUT_ID;
            Map configurations = ((AbstractFileSystemAccess)this.fileSystemAccess).getOutputConfigurations();
            boolean _containsKey = configurations.containsKey(COMMA_OUTPUT_ID);
            boolean bl = _not = !_containsKey;
            if (_not) {
                HashMap<String, OutputConfiguration> newConfigurations = new HashMap<String, OutputConfiguration>(configurations);
                newConfigurations.put(COMMA_OUTPUT_ID, COMMA_OUTPUT_CONF);
                ((AbstractFileSystemAccess)this.fileSystemAccess).setOutputConfigurations(newConfigurations);
            }
        } else {
            _xifexpression = this.generationFolder = "../comma-gen/" + this.generationFolder;
        }
        return _xifexpression;
    }

    public static String rootPrefix(IFileSystemAccess fileSystemAccess) {
        String _xifexpression = null;
        _xifexpression = fileSystemAccess instanceof CommaFileSystemAccess ? ((CommaFileSystemAccess)fileSystemAccess).getRootPrefix() : "";
        return _xifexpression;
    }

    public static String rootPrefixCommaGen(IFileSystemAccess fileSystemAccess) {
        String _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = fileSystemAccess instanceof CommaFileSystemAccess ? ((CommaFileSystemAccess)fileSystemAccess).getRootPrefix() : "";
        String root = _xifexpression;
        _xblockexpression = String.valueOf(root) + FOLDER_UP + "comma-gen/";
        return _xblockexpression;
    }

    public static String getGenerationFolder(IFileSystemAccess fileSystemAccess) {
        String _xifexpression = null;
        _xifexpression = fileSystemAccess instanceof CommaFileSystemAccess ? ((CommaFileSystemAccess)fileSystemAccess).generationFolder : "";
        return _xifexpression;
    }

    public static String getTraceMonitorPath(String traceFileName) {
        return String.valueOf(traceFileName) + "/";
    }

    public static String getRelativeMonitorResult(IFileSystemAccess fsa) {
        String _xblockexpression = null;
        String monitorResultFolder = "";
        if (fsa instanceof CommaFileSystemAccess) {
            String _plus_2;
            URI uri = URI.createFileURI((String)((CommaFileSystemAccess)fsa).generationFolder);
            String _get = uri.segments()[1];
            String _plus = String.valueOf(_get) + "/";
            String _get_1 = uri.segments()[2];
            String _plus_1 = String.valueOf(_plus) + _get_1;
            monitorResultFolder = _plus_2 = String.valueOf(_plus_1) + "/";
        }
        String _rootPrefixCommaGen = CommaFileSystemAccess.rootPrefixCommaGen(fsa);
        _xblockexpression = String.valueOf(_rootPrefixCommaGen) + monitorResultFolder;
        return _xblockexpression;
    }

    public static String getRelativeStatistics(IFileSystemAccess fsa) {
        String _xblockexpression = null;
        URI uri = URI.createFileURI((String)((CommaFileSystemAccess)fsa).generationFolder);
        String _rootPrefixCommaGen = CommaFileSystemAccess.rootPrefixCommaGen(fsa);
        String _get = uri.segments()[1];
        String _plus = String.valueOf(_rootPrefixCommaGen) + _get;
        String _plus_1 = String.valueOf(_plus) + "/";
        String _plus_2 = String.valueOf(_plus_1) + STATISTICS_FOLDER;
        _xblockexpression = String.valueOf(_plus_2) + "/";
        return _xblockexpression;
    }

    public static IFileSystemAccess2 getBasicFSA(IFileSystemAccess2 fsa) {
        if (fsa instanceof CommaFileSystemAccess) {
            return ((CommaFileSystemAccess)fsa).fileSystemAccess;
        }
        return fsa;
    }

    public static CommaFileSystemAccess getStatisticsFSA(IFileSystemAccess2 fsa, String taskName) {
        IFileSystemAccess2 _basicFSA = CommaFileSystemAccess.getBasicFSA(fsa);
        return new CommaFileSystemAccess(String.valueOf(taskName) + "/" + STATISTICS_FOLDER + "/", _basicFSA, true);
    }

    public static CommaFileSystemAccess getMonitorResultFSA(IFileSystemAccess2 fsa, String taskName, String traceFileName) {
        String _traceMonitorPath = CommaFileSystemAccess.getTraceMonitorPath(String.valueOf(taskName) + "/" + traceFileName);
        IFileSystemAccess2 _basicFSA = CommaFileSystemAccess.getBasicFSA(fsa);
        return new CommaFileSystemAccess(_traceMonitorPath, _basicFSA, true);
    }

    public static CommaFileSystemAccess getCommaGenFSA(IFileSystemAccess2 fsa) {
        IFileSystemAccess2 _basicFSA = CommaFileSystemAccess.getBasicFSA(fsa);
        return new CommaFileSystemAccess("", _basicFSA, true);
    }

    public URI getOutputConfiguration() {
        IPath path = null;
        if (this.fileSystemAccess instanceof AbstractFileSystemAccess) {
            path = this.getOutputPath((AbstractFileSystemAccess)this.fileSystemAccess);
            path = path.append(this.generationFolder);
        } else {
            Path _path = new Path("src-gen/");
            path = _path;
        }
        return URI.createFileURI((String)path.toString());
    }

    private IPath getOutputPath(AbstractFileSystemAccess access) {
        boolean _not;
        Map configs = access.getOutputConfigurations();
        boolean _isEmpty = configs.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _outputDirectory = ((OutputConfiguration)configs.get("DEFAULT_OUTPUT")).getOutputDirectory();
            Path path = new Path(_outputDirectory);
            Object _xifexpression = null;
            boolean _hasTrailingSeparator = path.hasTrailingSeparator();
            boolean _not_1 = !_hasTrailingSeparator;
            _xifexpression = _not_1 ? path.addTrailingSeparator() : path;
            return _xifexpression;
        }
        return new Path("src-gen/");
    }
}

