/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.ui.contentassist;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.project.project.ProjectPackage;
import org.eclipse.comma.project.ui.contentassist.TaskProposalProvider;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class ProjectProposalProvider
extends TaskProposalProvider {
    public static String BLOCK_DESCRIPTION = "Block containing tasks";
    public static String PROJECT_TITLE = "Project ";
    protected static String PROJECT_INFO = "The project contains information about the configuration of the model.";
    public static String GENERATE_DOCUMENTATION_TITLE = "Generate Documentation Block";
    public static String GENERATE_MONITORING_TITLE = "Generate Monitors Block";
    public static String GENERATE_MAPPINGS_TITLE = "Type Mappings Block";
    public static String GENERATE_MAPPINGS_SIMPLE_TITLE = "Type Mappings Simple";
    public static String GENERATE_STUBS_TITLE = "Generate Standalone Stubs Block";

    @Override
    public void complete_Project(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Project(model, ruleCall, context, acceptor);
        Iterable _allElements = this.getScopeProvider().getScope(model, ProjectPackage.Literals.INTERFACE_REFERENCE__INTERFACE).getAllElements();
        for (IEObjectDescription interface_ : _allElements) {
            this.addProjectTemplate(interface_.getName().getLastSegment(), context, acceptor);
        }
        this.addProjectTemplate(this.getInterfaceName(model), context, acceptor);
    }

    public void addProjectTemplate(String interfaceName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import \"<interface_name>.interface\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Project ");
        _builder.append(interfaceName);
        _builder.append("Project {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(String.valueOf(PROJECT_TITLE) + interfaceName, prop, PROJECT_INFO, 0, context));
    }

    @Override
    public void complete_MonitoringBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_MonitoringBlock(model, ruleCall, context, acceptor);
        boolean _containsBlock = this.containsBlock(model, ProjectPackage.Literals.MONITORING_BLOCK);
        if (_containsBlock) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Generate Monitors {");
        _builder.newLine();
        _builder.append("\t");
        String _format = String.format(this.TASK_MONITOR, this.getInterfaceName(model));
        _builder.append(_format, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Generate Monitors Block", proposal, BLOCK_DESCRIPTION, 1, context));
    }

    @Override
    public void complete_DocumentationGenerationBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_DocumentationGenerationBlock(model, ruleCall, context, acceptor);
        boolean _containsBlock = this.containsBlock(model, ProjectPackage.Literals.DOCUMENTATION_GENERATION_BLOCK);
        if (_containsBlock) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Generate Documentations {");
        _builder.newLine();
        _builder.append("\t");
        String _format = String.format(this.getDocumentationTask(), this.getInterfaceName(model));
        _builder.append(_format, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Generate Documentations Block", proposal, BLOCK_DESCRIPTION, 1, context));
    }

    @Override
    public void complete_TestClientGenerationBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_TestClientGenerationBlock(model, ruleCall, context, acceptor);
        boolean _containsBlock = this.containsBlock(model, ProjectPackage.Literals.TEST_CLIENT_GENERATION_BLOCK);
        if (_containsBlock) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Generate TestClient {");
        _builder.newLine();
        _builder.append("    ");
        String _complete_TestClientGenerationTaskBody = this.complete_TestClientGenerationTaskBody(model);
        _builder.append(_complete_TestClientGenerationTaskBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Generate Test Client Block", proposal, BLOCK_DESCRIPTION, 1, context));
    }

    @Override
    public void complete_SimulatorGenerationBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_SimulatorGenerationBlock(model, ruleCall, context, acceptor);
        boolean _containsBlock = this.containsBlock(model, ProjectPackage.Literals.SIMULATOR_GENERATION_BLOCK);
        if (_containsBlock) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Generate Simulator {");
        _builder.newLine();
        _builder.append("    ");
        String _complete_SimulatorGenerationTaskBody = this.complete_SimulatorGenerationTaskBody(model);
        _builder.append(_complete_SimulatorGenerationTaskBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Generate Simulator Block", proposal, BLOCK_DESCRIPTION, 1, context));
    }

    @Override
    public void complete_TestCasesGenerationBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_TestCasesGenerationBlock(model, ruleCall, context, acceptor);
        boolean _containsBlock = this.containsBlock(model, ProjectPackage.Literals.TEST_CASES_GENERATION_BLOCK);
        if (_containsBlock) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Generate TestCases {");
        _builder.newLine();
        _builder.append("\t");
        String _complete_TestCasesGenerationTaskBody = this.complete_TestCasesGenerationTaskBody(model);
        _builder.append(_complete_TestCasesGenerationTaskBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Generate Test Cases Generation Block", proposal, BLOCK_DESCRIPTION, 1, context));
    }

    @Override
    public void complete_ModelQualityChecksGenerationBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_ModelQualityChecksGenerationBlock(model, ruleCall, context, acceptor);
        boolean _containsBlock = this.containsBlock(model, ProjectPackage.Literals.MODEL_QUALITY_CHECKS_GENERATION_BLOCK);
        if (_containsBlock) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Generate ModelQualityChecks {");
        _builder.newLine();
        _builder.append("\t");
        String _complete_ModelQualityChecksGenerationTaskBody = this.complete_ModelQualityChecksGenerationTaskBody(model);
        _builder.append(_complete_ModelQualityChecksGenerationTaskBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Generate Model Quality Checks Generation Block", proposal, BLOCK_DESCRIPTION, 1, context));
    }

    @Override
    public void complete_UMLBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_UMLBlock(model, ruleCall, context, acceptor);
        boolean _containsBlock = this.containsBlock(model, ProjectPackage.Literals.UML_BLOCK);
        if (_containsBlock) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Generate UML {");
        _builder.newLine();
        _builder.append("\t");
        String _format = String.format(this.TASK_UML, this.getInterfaceName(model));
        _builder.append(_format, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Generate UML Block", proposal, BLOCK_DESCRIPTION, 1, context));
    }

    @Override
    public void complete_InterfaceMappings(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_InterfaceMappings(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("interface IName {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("any -> \"int\"");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String emptyProposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Interface Mapping", emptyProposal, "Interface mapping with dummy values", 3, context));
    }

    @Override
    public void complete_TypeMappings(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_TypeMappings(model, ruleCall, context, acceptor);
        this.addEmptyMapping(model, context, acceptor);
    }

    public void addEmptyMapping(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        acceptor.accept((ICompletionProposal)this.createTemplate("Type Mappings Task", this.TASK_TYPE_MAPPINGS, TaskProposalProvider.GENERATE_MAPPINGS_INFO, 2, context));
    }

    public void addSimpleMapping(EObject model, Iterable<String> globalSimpleTypes, Map<Signature, List<String>> ifSimpleTypes, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Type Mappings typeMappings{");
        _builder.newLine();
        for (String globalType : globalSimpleTypes) {
            _builder.append("\t");
            _builder.append(globalType, "\t");
            _builder.append(" -> \"int\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Set<Map.Entry<Signature, List<String>>> _entrySet = ifSimpleTypes.entrySet();
        for (Map.Entry<Signature, List<String>> ifSimpleType : _entrySet) {
            _builder.append("\t");
            _builder.append("interface ");
            String _name = ifSimpleType.getKey().getName();
            _builder.append(_name, "\t");
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            List<String> _value = ifSimpleType.getValue();
            for (String type : _value) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(type, "\t\t");
                _builder.append(" -> \"int\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(GENERATE_MAPPINGS_SIMPLE_TITLE, proposal, TaskProposalProvider.GENERATE_MAPPINGS_SIMPLE_INFO, 1, context));
    }

    public String getInterfaceName(EObject context) {
        List<Interface> interfaces = this.getInterfaces(context);
        boolean _isEmpty = interfaces.isEmpty();
        if (_isEmpty) {
            return TaskProposalProvider.INAME;
        }
        return interfaces.get(0).getName();
    }
}

