/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class MarkerTypeFieldFilter
extends CompatibilityFieldFilter {
    private static final String TAG_TYPES_DELIMITER = ":";
    private static final String TAG_SELECTED_TYPES = "selectedTypes";
    Collection<MarkerType> selectedTypes = new HashSet<MarkerType>();
    private MarkerContentGenerator contentGenerator;

    @Override
    public boolean select(MarkerItem item) {
        IMarker marker = item.getMarker();
        if (marker == null) {
            return this.contentGenerator.allTypesSelected(this.selectedTypes);
        }
        try {
            return this.selectedTypes.contains(MarkerTypesModel.getInstance().getType(marker.getType()));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    void setSelectedTypes(Collection<MarkerType> markerTypes, MarkerContentGenerator generator) {
        this.setContentGenerator(generator);
        this.selectedTypes = markerTypes;
    }

    Collection<MarkerType> getSelectedTypes() {
        return this.selectedTypes;
    }

    @Override
    public void saveSettings(IMemento memento) {
        if (this.selectedTypes.containsAll(this.contentGenerator.getMarkerTypes())) {
            return;
        }
        Iterator<MarkerType> selected = this.selectedTypes.iterator();
        StringBuilder settings = new StringBuilder();
        while (selected.hasNext()) {
            MarkerType markerType = selected.next();
            settings.append(markerType.getId());
            settings.append(TAG_TYPES_DELIMITER);
        }
        memento.putString(TAG_SELECTED_TYPES, settings.toString());
    }

    @Override
    public void loadSettings(IMemento memento) {
        String types = memento.getString(TAG_SELECTED_TYPES);
        if (types == null) {
            return;
        }
        this.selectedTypes.clear();
        int start = 0;
        int nextSpace = types.indexOf(TAG_TYPES_DELIMITER, 0);
        while (nextSpace > 0) {
            String typeId = types.substring(start, nextSpace);
            start = nextSpace + 1;
            nextSpace = types.indexOf(TAG_TYPES_DELIMITER, start);
            MarkerType type = this.contentGenerator.getType(typeId);
            if (type == null) continue;
            this.selectedTypes.add(type);
        }
    }

    @Override
    void loadLegacySettings(IMemento memento, MarkerContentGenerator generator) {
        this.setContentGenerator(generator);
        String setting = memento.getString("selectionStatus");
        if (setting != null) {
            this.selectedTypes.clear();
            ArrayList newTypes = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(setting);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType type;
                String id = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String status = null;
                if (stringTokenizer.hasMoreTokens()) {
                    status = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((type = this.contentGenerator.getType(id)) == null) continue;
                newTypes.remove(type);
                if ("false".equals(status) || this.selectedTypes.contains(type)) continue;
                this.selectedTypes.add(type);
            }
        }
    }

    @Override
    public void initialize(ProblemFilter problemFilter) {
        this.selectedTypes.clear();
        this.selectedTypes.addAll(problemFilter.getSelectedTypes());
    }

    void setContentGenerator(MarkerContentGenerator generator) {
        this.contentGenerator = generator;
        this.selectedTypes = new HashSet<MarkerType>();
        this.selectedTypes.addAll(generator.getMarkerTypes());
    }

    @Override
    public void populateWorkingCopy(MarkerFieldFilter copy) {
        super.populateWorkingCopy(copy);
        ((MarkerTypeFieldFilter)copy).selectedTypes = new HashSet<MarkerType>(this.selectedTypes);
        ((MarkerTypeFieldFilter)copy).contentGenerator = this.contentGenerator;
    }
}

