/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.comma.monitoring.lib.CDispatcher;
import org.eclipse.comma.monitoring.lib.CMonitorResults;
import org.eclipse.comma.monitoring.lib.CRecordsTracker;
import org.eclipse.comma.monitoring.lib.CTraceReader;
import org.eclipse.comma.monitoring.lib.CTraceResults;
import org.eclipse.comma.monitoring.lib.messages.CObservedCommand;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.messages.CObservedNotification;
import org.eclipse.comma.monitoring.lib.messages.CObservedReply;
import org.eclipse.comma.monitoring.lib.messages.CObservedSignal;
import org.eclipse.comma.monitoring.lib.utils.CMonitorFeedbackSender;
import org.eclipse.comma.monitoring.lib.utils.Utils;
import org.eclipse.comma.monitoring.lib.values.CBulkdata;
import org.eclipse.comma.monitoring.lib.values.CEnumValue;
import org.eclipse.comma.monitoring.lib.values.CRecord;
import org.eclipse.comma.monitoring.lib.values.CVector;

public class CFileJsonTraceReader
extends CTraceReader {
    private String timeStampPreviousEvent;
    private CRecordsTracker recordsTracker;
    private JsonStreamParser parser;
    private double timeDelta;
    private CMonitorFeedbackSender feedbackSender;
    private boolean runtimeMonitoring = false;

    public CFileJsonTraceReader(String tracePath, JsonStreamParser streamParser, CMonitorFeedbackSender feedbackSender) throws IOException {
        this.feedbackSender = feedbackSender;
        this.timeStampPreviousEvent = "";
        this.timeDelta = 0.0;
        if (streamParser == null) {
            try {
                InputStream inputStream = Files.newInputStream(Path.of(tracePath, new String[0]), new OpenOption[0]);
                this.parser = new JsonStreamParser((Reader)new InputStreamReader(inputStream, "UTF-8"));
            }
            catch (IOException e) {
                throw new IOException("the trace " + tracePath + " could not be read");
            }
        } else {
            this.parser = streamParser;
            this.runtimeMonitoring = true;
        }
    }

    public void processEvents(CDispatcher dispatcher, CTraceResults traceResults, CRecordsTracker recordsTracker) throws Exception {
        Optional<CObservedMessage> eventMessage = null;
        int lineNumberOfEvent = 0;
        String monitorType = dispatcher.getClass().getSimpleName();
        this.recordsTracker = recordsTracker;
        try {
            if (monitorType.equals("CComponentDispatcher") && this.parser.hasNext() && !this.runtimeMonitoring) {
                this.parser.next();
                ++lineNumberOfEvent;
            }
            while (this.parser.hasNext()) {
                JsonElement currentEvent = this.parser.next();
                if (!this.validateEvent(currentEvent, traceResults, ++lineNumberOfEvent)) {
                    return;
                }
                eventMessage = this.readMessage(currentEvent.getAsJsonObject(), lineNumberOfEvent);
                if (eventMessage.isPresent()) {
                    dispatcher.consume(eventMessage.get());
                    List<CMonitorResults> resultLastEvent = dispatcher.getIssuesForLastEvent();
                    if (this.feedbackSender == null || resultLastEvent.isEmpty()) continue;
                    Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
                    String resultsInJson = gson.toJson(resultLastEvent);
                    this.feedbackSender.write(resultsInJson);
                    continue;
                }
                throw new IllegalArgumentException("Events not present");
            }
            dispatcher.traceEnded();
            traceResults.setMonitorResults(dispatcher.getResults());
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            if (errorMsg == null) {
                errorMsg = "Error reading from event on line number  :  " + lineNumberOfEvent;
            }
            traceResults.markTraceError(errorMsg);
            if (this.feedbackSender != null) {
                Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
                String resultsInJson = gson.toJson((Object)traceResults);
                this.feedbackSender.write(resultsInJson);
            }
            try {
                dispatcher.traceEnded();
            }
            catch (Exception exception) {
                // empty catch block
            }
            traceResults.setMonitorResults(dispatcher.getResults());
        }
    }

    @Override
    public Optional<CObservedMessage> readMessage() throws Exception {
        return null;
    }

    public Optional<CObservedMessage> readMessage(JsonObject event, int lineNumberOfEvent) throws Exception {
        String kind = event.get("kind").getAsString();
        String interfaceName = event.get("interface").getAsString();
        String method = event.get("method").getAsString();
        String timeStamp = event.get("timeStamp").getAsString();
        String messageId = "lineNr" + lineNumberOfEvent;
        if (this.timeStampPreviousEvent.isEmpty()) {
            this.timeStampPreviousEvent = timeStamp;
        }
        this.timeDelta += this.getTimeDeltaOfEvents(this.timeStampPreviousEvent, timeStamp);
        this.timeStampPreviousEvent = timeStamp;
        String source = event.get("source").getAsString();
        String destination = event.get("destination").getAsString();
        String destinationPort = event.get("destinationPort").getAsString();
        String sourcePort = event.get("sourcePort").getAsString();
        CObservedMessage eventMessage = null;
        switch (kind) {
            case "Command": {
                eventMessage = new CObservedCommand(method, source, destination, sourcePort, destinationPort);
                break;
            }
            case "Signal": {
                eventMessage = new CObservedSignal(method, source, destination, sourcePort, destinationPort);
                break;
            }
            case "Notification": {
                eventMessage = new CObservedNotification(method, source, destination, sourcePort, destinationPort);
                break;
            }
            case "Reply": {
                eventMessage = new CObservedReply(method, source, destination, sourcePort, destinationPort);
                break;
            }
            default: {
                throw new Exception("Unknown transition action " + kind);
            }
        }
        eventMessage.setInterface(interfaceName);
        eventMessage.setMessageId(messageId);
        eventMessage.setTimestamp(timeStamp);
        eventMessage.setTimeDelta(Utils.roundDouble(this.timeDelta, 3));
        JsonArray parametersArray = null;
        if (event.has("parameters")) {
            if (!event.get("parameters").isJsonArray()) {
                throw new JsonSyntaxException("parameters did not contain a JSON Array");
            }
            parametersArray = event.getAsJsonArray("parameters");
            for (JsonElement parameter : parametersArray) {
                eventMessage.addParameter(this.getCommaTypeOf(parameter));
            }
        }
        return Optional.ofNullable(eventMessage);
    }

    public Object getCommaTypeOf(JsonElement parameter) throws Exception {
        String parameterType;
        JsonObject element = parameter.getAsJsonObject();
        switch (parameterType = element.get("type").getAsString()) {
            case "int": {
                return element.get("value").getAsLong();
            }
            case "bool": {
                return element.get("value").getAsBoolean();
            }
            case "real": {
                return element.get("value").getAsDouble();
            }
            case "string": {
                return element.get("value").getAsString();
            }
            case "bulkdata": {
                int size = element.get("value").getAsInt();
                return new CBulkdata(size);
            }
            case "enum": {
                return new CEnumValue(element.get("value").getAsString());
            }
            case "vector": {
                CVector vectorValue = new CVector();
                String typeOfElements = element.get("typeElem").getAsString();
                if (!typeOfElements.equals("vector") && !typeOfElements.equals("record")) {
                    if (!element.get("value").isJsonArray()) {
                        throw new JsonSyntaxException("Vector did not contain a vector Array");
                    }
                    element.get("value").getAsJsonArray().forEach(item -> {
                        JsonObject value = new JsonObject();
                        value.addProperty("type", typeOfElements);
                        value.add("value", item);
                        try {
                            vectorValue.addNew(this.getCommaTypeOf((JsonElement)value));
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(e);
                        }
                    });
                } else {
                    if (!element.get("value").isJsonArray()) {
                        throw new JsonSyntaxException("Vector did not contain a vector Array");
                    }
                    element.get("value").getAsJsonArray().forEach(itemArray -> {
                        try {
                            vectorValue.addNew(this.getCommaTypeOf((JsonElement)itemArray));
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(e);
                        }
                    });
                }
                return vectorValue;
            }
            case "record": {
                String recordName = element.get("record").getAsString();
                JsonObject recordFieldsFromTraceFile = element.get("value").getAsJsonObject();
                recordName = recordName.replace(".", "_");
                CRecord record = new CRecord(recordName);
                Map<String, String> fieldsOfRecordInterfaceModel = this.recordsTracker.getFieldsOfRecord(recordName);
                for (Map.Entry<String, String> field : fieldsOfRecordInterfaceModel.entrySet()) {
                    if (!recordFieldsFromTraceFile.has(field.getKey())) {
                        throw new IllegalArgumentException("The record " + recordName + " does not contain the field " + field.getKey());
                    }
                    String nameOfField = field.getKey();
                    String typeOfField = field.getValue();
                    if (typeOfField.equals("record") || typeOfField.equals("vector")) {
                        record.setValueOfField(nameOfField, this.getCommaTypeOf((JsonElement)recordFieldsFromTraceFile.get(nameOfField).getAsJsonObject()));
                        continue;
                    }
                    JsonObject f = new JsonObject();
                    String valueField = recordFieldsFromTraceFile.get(nameOfField).getAsString();
                    f.addProperty("type", typeOfField);
                    f.addProperty("value", valueField);
                    record.setValueOfField(nameOfField, this.getCommaTypeOf((JsonElement)f));
                }
                return record;
            }
        }
        throw new Exception("unsupported type");
    }

    private double getTimeDeltaOfEvents(String previousEvent, String currentEvent) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        double timeDelta = 0.0;
        try {
            LocalDateTime currentEventDateTime = LocalDateTime.parse(currentEvent, formatter);
            LocalDateTime previousEventDateTime = LocalDateTime.parse(previousEvent, formatter);
            Duration duration = Duration.between(previousEventDateTime, currentEventDateTime);
            if (duration.isNegative()) {
                throw new IllegalArgumentException("The timestamp of current event " + currentEventDateTime + " cannot be earlier than the previous event " + previousEventDateTime);
            }
            timeDelta = duration.toMillis();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.valueOf(currentEvent) + " is given in wrong  date format. Date format must be of iso 8601 : yyyy-MM-ddTHH:mm:ss.SSSXXX ");
        }
        return timeDelta;
    }

    protected Object processRecord(JsonObject recordObject, String nameOfInterface) throws Exception {
        throw new Exception("unexpected record value. Model does not use record types.");
    }

    private boolean validateEvent(JsonElement event, CTraceResults traceResults, int lineNumberOfEvent) {
        List<String> requiredKeys = Arrays.asList("interface", "method", "kind", "source", "sourcePort", "destination", "destinationPort", "timeStamp");
        for (String key : requiredKeys) {
            JsonObject objectKey = event.getAsJsonObject();
            if (!objectKey.has(key)) {
                traceResults.markTraceError("Event on line " + lineNumberOfEvent + ": misses or incorrectly typed required key " + key);
                return false;
            }
            if (!objectKey.get(key).isJsonNull() && !objectKey.get(key).getAsString().isBlank()) continue;
            traceResults.markTraceError("Event on line " + lineNumberOfEvent + ": value of key " + key + " cannot be null or empty");
            return false;
        }
        return true;
    }
}

