/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongIteratorIterate {
    private LongIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(LongIterator iterator, LongProcedure procedure) {
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public static <R extends MutableLongCollection> R select(LongIterator iterator, LongPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            long item = iterator.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableLongCollection> R reject(LongIterator iterator, LongPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            long item = iterator.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(LongIterator iterator, LongToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator.hasNext()) {
            long item = iterator.next();
            targetCollection.add((Object)function.valueOf(item));
        }
        return targetCollection;
    }

    public static long detectIfNone(LongIterator iterator, LongPredicate predicate, long ifNone) {
        while (iterator.hasNext()) {
            long item = iterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(LongIterator iterator, LongPredicate predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean anySatisfy(LongIterator iterator, LongPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(LongIterator iterator, LongPredicate predicate) {
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(LongIterator iterator, LongPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(LongIterator iterator, T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public static long sum(LongIterator iterator) {
        long sum = 0L;
        while (iterator.hasNext()) {
            sum += iterator.next();
        }
        return sum;
    }

    public static long max(LongIterator iterator) {
        long max = iterator.next();
        while (iterator.hasNext()) {
            long next = iterator.next();
            if (max >= next) continue;
            max = next;
        }
        return max;
    }

    public static long min(LongIterator iterator) {
        long min = iterator.next();
        while (iterator.hasNext()) {
            long next = iterator.next();
            if (next >= min) continue;
            min = next;
        }
        return min;
    }
}

