/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableByteStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableByteStack;
import org.eclipse.collections.impl.stack.mutable.primitive.ByteArrayStack;

public class MutableByteStackFactoryImpl
implements MutableByteStackFactory {
    public MutableByteStack empty() {
        return new ByteArrayStack();
    }

    public MutableByteStack of() {
        return this.empty();
    }

    public MutableByteStack with() {
        return this.empty();
    }

    public MutableByteStack of(byte ... items) {
        return this.with(items);
    }

    public MutableByteStack with(byte ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return ByteArrayStack.newStackWith(items);
    }

    public MutableByteStack ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    public MutableByteStack withAll(ByteIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ByteArrayStack.newStack(items);
    }

    public MutableByteStack ofAllReversed(ByteIterable items) {
        return this.withAllReversed(items);
    }

    public MutableByteStack withAllReversed(ByteIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ByteArrayStack.newStackFromTopToBottom(items);
    }
}

