/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectIterator<T>
implements Iterator<T> {
    private static final Object NULL = new Object();
    private final Iterator<T> iterator;
    private final Predicate<? super T> predicate;
    private Object next = NULL;

    public SelectIterator(Iterable<T> iterable, Predicate<? super T> predicate) {
        this(iterable.iterator(), predicate);
    }

    public SelectIterator(Iterator<T> iterator, Predicate<? super T> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a select iterator");
    }

    @Override
    public boolean hasNext() {
        if (this.next != NULL) {
            return true;
        }
        while (this.iterator.hasNext()) {
            T temp = this.iterator.next();
            if (!this.predicate.accept(temp)) continue;
            this.next = temp;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.next != NULL || this.hasNext()) {
            Object temp = this.next;
            this.next = NULL;
            return (T)temp;
        }
        throw new NoSuchElementException();
    }
}

