/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable;

import java.io.Serializable;
import java.util.Collection;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.partition.PartitionMutableCollection;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import org.eclipse.collections.impl.collection.mutable.CollectionAdapter;
import org.eclipse.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import org.eclipse.collections.impl.collection.mutable.UnmodifiableMutableCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SynchronizedMutableCollection<T>
extends AbstractSynchronizedMutableCollection<T>
implements Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedMutableCollection(MutableCollection<T> newCollection) {
        this(newCollection, null);
    }

    SynchronizedMutableCollection(MutableCollection<T> newCollection, Object newLock) {
        super(newCollection, newLock);
    }

    public static <E, C extends Collection<E>> SynchronizedMutableCollection<E> of(C collection) {
        return new SynchronizedMutableCollection(CollectionAdapter.adapt(collection));
    }

    public static <E, C extends Collection<E>> SynchronizedMutableCollection<E> of(C collection, Object lock) {
        return new SynchronizedMutableCollection(CollectionAdapter.adapt(collection), lock);
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy(this.getDelegate());
    }

    public MutableCollection<T> with(T element) {
        this.add(element);
        return this;
    }

    public MutableCollection<T> without(T element) {
        this.remove(element);
        return this;
    }

    public MutableCollection<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public MutableCollection<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableMutableCollection(this);
        }
    }

    public MutableCollection<T> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableCollection<T> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> tap(Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().each(procedure);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> select(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableCollection<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> reject(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableCollection<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableCollection<T> partition(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> PartitionMutableCollection<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().partitionWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanCollection collectBoolean(BooleanFunction<? super T> booleanFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteCollection collectByte(ByteFunction<? super T> byteFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharCollection collectChar(CharFunction<? super T> charFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleCollection collectDouble(DoubleFunction<? super T> doubleFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatCollection collectFloat(FloatFunction<? super T> floatFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection collectInt(IntFunction<? super T> intFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectInt(intFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongCollection collectLong(LongFunction<? super T> longFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortCollection collectShort(ShortFunction<? super T> shortFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<Pair<T, Integer>> zipWithIndex() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableCollection<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectInstancesOf(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableCollection<V> collect(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, V> MutableCollection<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableCollection<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableCollection<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableCollection<Pair<T, S>> zip(Iterable<S> that) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().zip(that);
        }
    }
}

