/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableCharBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableCharEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableCharHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableCharSingletonBag;

public enum ImmutableCharBagFactoryImpl implements ImmutableCharBagFactory
{
    INSTANCE;


    @Override
    public ImmutableCharBag empty() {
        return ImmutableCharEmptyBag.INSTANCE;
    }

    @Override
    public ImmutableCharBag of() {
        return this.empty();
    }

    @Override
    public ImmutableCharBag with() {
        return this.empty();
    }

    @Override
    public ImmutableCharBag of(char one) {
        return this.with(one);
    }

    @Override
    public ImmutableCharBag with(char one) {
        return new ImmutableCharSingletonBag(one);
    }

    @Override
    public ImmutableCharBag of(char ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableCharBag with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharHashBag.newBagWith(items);
    }

    @Override
    public ImmutableCharBag ofAll(CharIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableCharBag withAll(CharIterable items) {
        if (items instanceof ImmutableCharBag) {
            return (ImmutableCharBag)items;
        }
        return this.with(items.toArray());
    }
}

