/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.MutableIntFloatMapFactory;
import org.eclipse.collections.api.map.primitive.MutableIntFloatMap;
import org.eclipse.collections.api.map.primitive.IntFloatMap;

/**
 * MutableIntFloatMapFactoryImpl is a factory implementation which creates instances of type {@link MutableIntFloatMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public enum MutableIntFloatMapFactoryImpl implements MutableIntFloatMapFactory
{
    INSTANCE;

    @Override
    public MutableIntFloatMap empty()
    {
        return new IntFloatHashMap(0);
    }

    @Override
    public MutableIntFloatMap of()
    {
        return this.empty();
    }

    @Override
    public MutableIntFloatMap with()
    {
        return this.empty();
    }

    @Override
    public MutableIntFloatMap ofAll(IntFloatMap map)
    {
        return this.withAll(map);
    }

    @Override
    public MutableIntFloatMap withAll(IntFloatMap map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new IntFloatHashMap(map);
    }
}
