/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableIntSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import org.eclipse.collections.impl.set.primitive.AbstractIntSet;

public final class IntHashSet
extends AbstractIntSet
implements MutableIntSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int EMPTY = 0;
    private static final int REMOVED = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private int[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public IntHashSet() {
        this.allocateTable(16);
    }

    public IntHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public IntHashSet(int ... elements) {
        this();
        this.addAll(elements);
    }

    public IntHashSet(IntHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static IntHashSet newSet(IntIterable source) {
        if (source instanceof IntHashSet) {
            return new IntHashSet((IntHashSet)source);
        }
        return IntHashSet.newSetWith(source.toArray());
    }

    public static IntHashSet newSetWith(int ... source) {
        return new IntHashSet(source);
    }

    private static boolean isBetweenZeroAndThirtyOne(int value) {
        return value >= 0 && value <= 31;
    }

    @Override
    public int hashCode() {
        int value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += value;
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!IntHashSet.isNonSentinel(this.table[i])) continue;
                result += this.table[i];
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            int value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean add(int element) {
        if (IntHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (this.table[index] == element) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (this.table[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    @Override
    public boolean addAll(int ... source) {
        int oldSize = this.size();
        for (int item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean addAll(IntIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof IntHashSet) {
            IntHashSet hashSet = (IntHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (int item : hashSet.table) {
                if (!IntHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                int item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean remove(int value) {
        if (IntHashSet.isBetweenZeroAndThirtyOne(value)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne &= ~(1 << value);
            if (this.zeroToThirtyOne == initial) {
                return false;
            }
            --this.zeroToThirtyOneOccupied;
            return true;
        }
        int index = this.probe(value);
        if (this.table[index] == value) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(IntIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof IntHashSet) {
            IntHashSet hashSet = (IntHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (int item : hashSet.table) {
                if (!IntHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                int item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(int ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (int item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(IntIterable source) {
        int oldSize = this.size();
        IntSet sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
        IntHashSet retained = this.select(sourceSet::contains);
        if (retained.size() != oldSize) {
            this.zeroToThirtyOne = retained.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = retained.zeroToThirtyOneOccupied;
            this.occupiedWithData = retained.occupiedWithData;
            this.occupiedWithSentinels = retained.occupiedWithSentinels;
            this.table = retained.table;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(int ... source) {
        return this.retainAll(IntHashSet.newSetWith(source));
    }

    @Override
    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new int[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, 0);
        }
    }

    @Override
    public IntHashSet with(int element) {
        this.add(element);
        return this;
    }

    @Override
    public IntHashSet without(int element) {
        this.remove(element);
        return this;
    }

    @Override
    public IntHashSet withAll(IntIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    @Override
    public IntHashSet withoutAll(IntIterable elements) {
        this.removeAll(elements);
        return this;
    }

    @Override
    public MutableIntSet asUnmodifiable() {
        return new UnmodifiableIntSet(this);
    }

    @Override
    public MutableIntSet asSynchronized() {
        return new SynchronizedIntSet(this);
    }

    @Override
    public ImmutableIntSet toImmutable() {
        if (this.size() == 0) {
            return IntSets.immutable.with();
        }
        if (this.size() == 1) {
            return IntSets.immutable.with(this.intIterator().next());
        }
        IntHashSet mutableSet = IntHashSet.newSetWith(this.toArray());
        return new ImmutableIntHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    @Override
    public MutableIntIterator intIterator() {
        return new InternalIntIterator();
    }

    @Override
    public int[] toArray() {
        int value;
        int[] array = new int[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            array[j] = value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!IntHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    @Override
    public boolean contains(int value) {
        if (IntHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> value & 1) != 0;
        }
        return this.table[this.probe(value)] == value;
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    @Override
    public IntHashSet select(IntPredicate predicate) {
        return this.select(predicate, new IntHashSet());
    }

    @Override
    public <R extends MutableIntCollection> R select(IntPredicate predicate, R target) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            target.add(value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public IntHashSet reject(IntPredicate predicate) {
        return this.reject(predicate, new IntHashSet());
    }

    @Override
    public <R extends MutableIntCollection> R reject(IntPredicate predicate, R target) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            target.add(value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        return this.collect(function, UnifiedSet.newSet(this.size()));
    }

    @Override
    public <V, R extends Collection<V>> R collect(IntToObjectFunction<? extends V> function, R target) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    @Override
    public int count(IntPredicate predicate) {
        int value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    @Override
    public long sum() {
        int value;
        long result = 0L;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += (long)value;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            result += (long)value2;
        }
        return result;
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (int value : this.table) {
            if (!IntHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (int value : this.table) {
            if (!IntHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
            min = value;
            isMinSet = true;
        }
        return min;
    }

    @Override
    public IntSet freeze() {
        if (this.size() == 0) {
            return IntSets.immutable.with();
        }
        if (this.size() == 1) {
            return IntSets.immutable.with(this.intIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableIntHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeInt(value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            out.writeInt(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readInt());
        }
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        int value;
        T result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.table.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.table.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        int[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    private void allocateTable(int sizeToAllocate) {
        this.table = new int[sizeToAllocate];
    }

    int probe(int element) {
        int index = this.spreadAndMask(element);
        int valueAtIndex = this.table[index];
        if (valueAtIndex == element || valueAtIndex == 0) {
            return index;
        }
        int removedIndex = valueAtIndex == 1 ? index : -1;
        for (int i = 1; i < 8; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            valueAtIndex = this.table[nextIndex];
            if (valueAtIndex == element) {
                return nextIndex;
            }
            if (valueAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (valueAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(int element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 8; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            int valueAtIndex = this.table[nextIndex];
            if (valueAtIndex == element) {
                return nextIndex;
            }
            if (valueAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (valueAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(int element, int removedIndex) {
        int nextIndex = Integer.reverse(SpreadFunctions.intSpreadOne(element));
        int spreadTwo = Integer.reverse(SpreadFunctions.intSpreadTwo(element)) | 1;
        int valueAtIndex;
        while ((valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (valueAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (valueAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(int element) {
        int code = SpreadFunctions.intSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(int element) {
        int code = SpreadFunctions.intSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        int[] copy = new int[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, this.table.length);
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        int capacity = this.table.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.table.length / 4;
    }

    private static boolean isNonSentinel(int value) {
        return value != 0 && value != 1;
    }

    private class InternalIntIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private int zeroToThirtyOne;

        private InternalIntIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IntHashSet.this.size();
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32) {
                if (IntHashSet.this.contains(this.zeroToThirtyOne)) {
                    int result = this.zeroToThirtyOne++;
                    return result;
                }
                ++this.zeroToThirtyOne;
            }
            int[] table = IntHashSet.this.table;
            while (!IntHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            int result = table[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            int removeValue;
            if (this.count == 0) {
                throw new IllegalStateException();
            }
            if (this.zeroToThirtyOne <= 32 && this.position == 0) {
                if (IntHashSet.this.zeroToThirtyOne != (IntHashSet.this.zeroToThirtyOne | 1 << this.zeroToThirtyOne - 1)) {
                    throw new IllegalStateException();
                }
                removeValue = this.zeroToThirtyOne - 1;
            } else {
                if (IntHashSet.this.table[this.position - 1] == 1) {
                    throw new IllegalStateException();
                }
                removeValue = IntHashSet.this.table[this.position - 1];
            }
            IntHashSet.this.remove(removeValue);
            --this.count;
        }
    }

    private static final class ImmutableIntHashSet
    extends AbstractImmutableIntSet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableIntHashSet(int[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use IntSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableIntSet newSetWith(int ... elements) {
            return IntHashSet.newSetWith(elements).toImmutable();
        }

        @Override
        public int hashCode() {
            int value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += value;
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!IntHashSet.isNonSentinel(this.table[i])) continue;
                    result += this.table[i];
                }
            }
            return result;
        }

        @Override
        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                int value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                    value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (int value2 : this.table) {
                    if (!IntHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public IntIterator intIterator() {
            return new InternalIntIterator();
        }

        @Override
        public int[] toArray() {
            int value;
            int[] array = new int[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                array[j] = value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!IntHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        @Override
        public boolean contains(int value) {
            if (IntHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> value & 1) != 0;
            }
            return this.table[this.probe(value)] == value;
        }

        @Override
        public void forEach(IntProcedure procedure) {
            this.each(procedure);
        }

        @Override
        public void each(IntProcedure procedure) {
            int value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        @Override
        public ImmutableIntSet select(IntPredicate predicate) {
            return this.select(predicate, new IntHashSet()).toImmutable();
        }

        @Override
        public ImmutableIntSet reject(IntPredicate predicate) {
            return this.reject(predicate, new IntHashSet()).toImmutable();
        }

        @Override
        public <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function) {
            MutableSet set = this.collect(function, UnifiedSet.newSet(this.size()));
            return set.toImmutable();
        }

        @Override
        public int detectIfNone(IntPredicate predicate, int ifNone) {
            int value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        @Override
        public int count(IntPredicate predicate) {
            int value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean anySatisfy(IntPredicate predicate) {
            int value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allSatisfy(IntPredicate predicate) {
            int value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noneSatisfy(IntPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        @Override
        public long sum() {
            int value;
            long result = 0L;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += (long)value;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2)) continue;
                result += (long)value2;
            }
            return result;
        }

        @Override
        public int max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (int value : this.table) {
                if (!IntHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        @Override
        public int min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (int value : this.table) {
                if (!IntHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
                min = value;
                isMinSet = true;
            }
            return min;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            int value;
            T result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        private Object writeReplace() {
            return new ImmutableIntSetSerializationProxy(this);
        }

        int probe(int element) {
            int index = this.spreadAndMask(element);
            int valueAtIndex = this.table[index];
            if (valueAtIndex == element || valueAtIndex == 0) {
                return index;
            }
            int removedIndex = valueAtIndex == 1 ? index : -1;
            for (int i = 1; i < 8; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                valueAtIndex = this.table[nextIndex];
                if (valueAtIndex == element) {
                    return nextIndex;
                }
                if (valueAtIndex == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (valueAtIndex != 1 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeTwo(element, removedIndex);
        }

        int probeTwo(int element, int removedIndex) {
            int index = this.spreadTwoAndMask(element);
            for (int i = 0; i < 8; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                int valueAtIndex = this.table[nextIndex];
                if (valueAtIndex == element) {
                    return nextIndex;
                }
                if (valueAtIndex == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (valueAtIndex != 1 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeThree(element, removedIndex);
        }

        int probeThree(int element, int removedIndex) {
            int nextIndex = Integer.reverse(SpreadFunctions.intSpreadOne(element));
            int spreadTwo = Integer.reverse(SpreadFunctions.intSpreadTwo(element)) | 1;
            int valueAtIndex;
            while ((valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
                if (valueAtIndex == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (valueAtIndex != 1 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return nextIndex;
        }

        int spreadAndMask(int element) {
            int code = SpreadFunctions.intSpreadOne(element);
            return this.mask(code);
        }

        int spreadTwoAndMask(int element) {
            int code = SpreadFunctions.intSpreadTwo(element);
            return this.mask(code);
        }

        private int mask(int spread) {
            return spread & this.table.length - 1;
        }

        private class InternalIntIterator
        implements IntIterator {
            private int count;
            private int position;
            private int zeroToThirtyOne;

            private InternalIntIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.count < ImmutableIntHashSet.this.size();
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32) {
                    if (ImmutableIntHashSet.this.contains(this.zeroToThirtyOne)) {
                        int result = this.zeroToThirtyOne++;
                        return result;
                    }
                    ++this.zeroToThirtyOne;
                }
                int[] table = ImmutableIntHashSet.this.table;
                while (!IntHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                int result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }
}

