/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableIntObjectMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntObjectSingletonMap;

public class ImmutableIntObjectMapFactoryImpl
implements ImmutableIntObjectMapFactory {
    @Override
    public <V> ImmutableIntObjectMap<V> empty() {
        return ImmutableIntObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableIntObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableIntObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableIntObjectMap<V> of(int key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableIntObjectMap<V> with(int key, V value) {
        return new ImmutableIntObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableIntObjectMap<V> ofAll(IntObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    @Override
    public <V> ImmutableIntObjectMap<V> withAll(IntObjectMap<? extends V> map) {
        if (map instanceof ImmutableIntObjectMap) {
            return (ImmutableIntObjectMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            int[] array = new int[1];
            map.forEachKey(each -> {
                array[0] = each;
            });
            return new ImmutableIntObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableIntObjectHashMap<V>(map);
    }
}

