/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableFloatIntMapFactory;
import org.eclipse.collections.api.map.primitive.FloatIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatIntMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatIntEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatIntHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatIntSingletonMap;

public class ImmutableFloatIntMapFactoryImpl
implements ImmutableFloatIntMapFactory {
    @Override
    public ImmutableFloatIntMap empty() {
        return ImmutableFloatIntEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableFloatIntMap of() {
        return this.empty();
    }

    @Override
    public ImmutableFloatIntMap with() {
        return this.empty();
    }

    @Override
    public ImmutableFloatIntMap of(float key, int value) {
        return this.with(key, value);
    }

    @Override
    public ImmutableFloatIntMap with(float key, int value) {
        return new ImmutableFloatIntSingletonMap(key, value);
    }

    @Override
    public ImmutableFloatIntMap ofAll(FloatIntMap map) {
        return this.withAll(map);
    }

    @Override
    public ImmutableFloatIntMap withAll(FloatIntMap map) {
        if (map instanceof ImmutableFloatIntMap) {
            return (ImmutableFloatIntMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatIntSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatIntHashMap(map);
    }
}

