/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableLongBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableLongEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableLongHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableLongSingletonBag;

public class ImmutableLongBagFactoryImpl
implements ImmutableLongBagFactory {
    @Override
    public ImmutableLongBag empty() {
        return ImmutableLongEmptyBag.INSTANCE;
    }

    @Override
    public ImmutableLongBag of() {
        return this.empty();
    }

    @Override
    public ImmutableLongBag with() {
        return this.empty();
    }

    @Override
    public ImmutableLongBag of(long one) {
        return this.with(one);
    }

    @Override
    public ImmutableLongBag with(long one) {
        return new ImmutableLongSingletonBag(one);
    }

    @Override
    public ImmutableLongBag of(long ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableLongBag with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableLongHashBag.newBagWith(items);
    }

    @Override
    public ImmutableLongBag ofAll(LongIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableLongBag withAll(LongIterable items) {
        if (items instanceof ImmutableLongBag) {
            return (ImmutableLongBag)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableLongBag ofAll(LongStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableLongBag withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

