/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.IfProcedure;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterableImpl;
import org.eclipse.collections.impl.lazy.parallel.Batch;

@Beta
public class ParallelSelectIterable<T>
extends AbstractParallelIterableImpl<T, Batch<T>> {
    private final AbstractParallelIterable<T, ? extends Batch<T>> parallelIterable;
    private final Predicate<? super T> predicate;

    public ParallelSelectIterable(AbstractParallelIterable<T, ? extends Batch<T>> parallelIterable, Predicate<? super T> predicate) {
        this.parallelIterable = parallelIterable;
        this.predicate = predicate;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<Batch<T>> split() {
        return this.parallelIterable.split().collect((Function & Serializable)eachBatch -> eachBatch.select(this.predicate));
    }

    public void forEach(Procedure<? super T> procedure) {
        this.parallelIterable.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.anySatisfy(Predicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.allSatisfy(new SelectAllSatisfyPredicate<T>(this.predicate, predicate));
    }

    public T detect(Predicate<? super T> predicate) {
        return (T)this.parallelIterable.detect(Predicates.and(this.predicate, predicate));
    }

    public Object[] toArray() {
        return this.parallelIterable.toList().select(this.predicate).toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.parallelIterable.toList().select(this.predicate).toArray((Object[])array);
    }

    private static final class SelectAllSatisfyPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> left;
        private final Predicate<? super T> right;

        private SelectAllSatisfyPredicate(Predicate<? super T> left, Predicate<? super T> right) {
            this.left = left;
            this.right = right;
        }

        public boolean accept(T each) {
            boolean leftResult = this.left.accept(each);
            return !leftResult || this.right.accept(each);
        }
    }
}

