/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.map.primitive;

import java.util.Set;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.ObjectObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ObjectCharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectCharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.map.primitive.CharObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectCharMap;
import org.eclipse.collections.api.tuple.primitive.ObjectCharPair;

public interface ObjectCharMap<K>
extends CharIterable {
    public char get(Object var1);

    public char getOrThrow(Object var1);

    public char getIfAbsent(Object var1, char var2);

    public boolean containsKey(Object var1);

    public boolean containsValue(char var1);

    public void forEachValue(CharProcedure var1);

    public void forEachKey(Procedure<? super K> var1);

    public void forEachKeyValue(ObjectCharProcedure<? super K> var1);

    public CharObjectMap<K> flipUniqueValues();

    default public boolean allSatisfyKeyValue(ObjectCharPredicate<K> predicate) {
        for (ObjectCharPair objectCharPair : this.keyValuesView()) {
            if (predicate.accept(objectCharPair.getOne(), objectCharPair.getTwo())) continue;
            return false;
        }
        return true;
    }

    default public <IV> IV injectIntoKeyValue(IV injectedValue, ObjectObjectCharToObjectFunction<? super IV, ? super K, ? extends IV> function) {
        Object[] result = new Object[]{injectedValue};
        this.forEachKeyValue((key, value) -> {
            result[0] = function.valueOf((Object)result[0], (Object)key, value);
        });
        return (IV)result[0];
    }

    public ObjectCharMap<K> select(ObjectCharPredicate<? super K> var1);

    public ObjectCharMap<K> reject(ObjectCharPredicate<? super K> var1);

    @Override
    default public ObjectCharMap<K> tap(CharProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public String toString();

    public ImmutableObjectCharMap<K> toImmutable();

    public Set<K> keySet();

    public MutableCharCollection values();

    public LazyIterable<K> keysView();

    public RichIterable<ObjectCharPair<K>> keyValuesView();
}

