/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction0;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortIntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToIntFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.factory.primitive.IntShortMaps;
import org.eclipse.collections.api.factory.primitive.ShortIntMaps;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.map.primitive.ImmutableShortIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortIntMap;
import org.eclipse.collections.api.map.primitive.ShortIntMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortIntPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableShortKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableShortMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableShortKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedShortIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableShortIntMap;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ShortIntHashMap
extends AbstractMutableIntValuesMap
implements MutableShortIntMap,
Externalizable,
MutableShortKeysMap {
    private static final int EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private short[] keys;
    private int[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableIntValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public ShortIntHashMap() {
        this.allocateTable(16);
    }

    public ShortIntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public ShortIntHashMap(ShortIntMap map) {
        if (map instanceof ShortIntHashMap && ((ShortIntHashMap)map).occupiedWithSentinels == 0) {
            ShortIntHashMap hashMap = (ShortIntHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static ShortIntHashMap newWithKeysValues(short key1, int value1) {
        return new ShortIntHashMap(1).withKeyValue(key1, value1);
    }

    public static ShortIntHashMap newWithKeysValues(short key1, int value1, short key2, int value2) {
        return new ShortIntHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ShortIntHashMap newWithKeysValues(short key1, int value1, short key2, int value2, short key3, int value3) {
        return new ShortIntHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ShortIntHashMap newWithKeysValues(short key1, int value1, short key2, int value2, short key3, int value3, short key4, int value4) {
        return new ShortIntHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableIntValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected int getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected int getValueAtIndex(int index) {
        return this.values[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortIntMap)) {
            return false;
        }
        ShortIntMap other = (ShortIntMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((short)0) || other.containsKey((short)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((short)0) || this.sentinelValues.zeroValue != other.getOrThrow((short)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((short)1) || this.sentinelValues.oneValue != other.getOrThrow((short)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortIntHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortIntHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableIntIterator intIterator() {
        return new InternalIntIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortIntHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, 0);
    }

    @Override
    public void put(short key, int value) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(int value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(int value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(ShortIntMap map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(ShortIntToIntFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortIntHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.keys[i], this.values[i]);
        }
    }

    @Override
    public void removeKey(short key) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(short key) {
        this.removeKey(key);
    }

    @Override
    public int removeKeyIfAbsent(short key, int value) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            int oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            int oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public int getIfAbsentPut(short key, int value) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public int getAndPut(short key, int putValue, int defaultValue) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsZeroKey) {
                int existingValue = this.sentinelValues.zeroValue;
                this.sentinelValues.zeroValue = putValue;
                return existingValue;
            }
            this.addEmptyKeyValue(putValue);
            return defaultValue;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsOneKey) {
                int existingValue = this.sentinelValues.oneValue;
                this.sentinelValues.oneValue = putValue;
                return existingValue;
            }
            this.addRemovedKeyValue(putValue);
            return defaultValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int existingValue = this.values[index];
            this.values[index] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public int getIfAbsentPut(short key, IntFunction0 function) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> int getIfAbsentPutWith(short key, IntFunction<? super P> function, P parameter) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.intValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.intValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.intValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public int getIfAbsentPutWithKey(short key, ShortToIntFunction function) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public int addToValue(short key, int toBeAdded) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(short key, int value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        short[] copy = new short[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public int updateValue(short key, int initialValueIfAbsent, IntToIntFunction function) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        int value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public ShortIntHashMap withKeyValue(short key1, int value1) {
        this.put(key1, value1);
        return this;
    }

    public ShortIntHashMap withKeysValues(short key1, int value1, short key2, int value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ShortIntHashMap withKeysValues(short key1, int value1, short key2, int value2, short key3, int value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ShortIntHashMap withKeysValues(short key1, int value1, short key2, int value2, short key3, int value3, short key4, int value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public ShortIntHashMap withoutKey(short key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public ShortIntHashMap withoutAllKeys(ShortIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    @Override
    public MutableShortIntMap asUnmodifiable() {
        return new UnmodifiableShortIntMap(this);
    }

    @Override
    public MutableShortIntMap asSynchronized() {
        return new SynchronizedShortIntMap(this);
    }

    @Override
    public ImmutableShortIntMap toImmutable() {
        return ShortIntMaps.immutable.ofAll(this);
    }

    @Override
    public int get(short key) {
        return this.getIfAbsent(key, 0);
    }

    @Override
    public int getIfAbsent(short key, int ifAbsent) {
        if (ShortIntHashMap.isEmptyKey(key) || ShortIntHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private int getForSentinel(short key, int ifAbsent) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private int slowGetIfAbsent(short key, int ifAbsent) {
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private int fastGetIfAbsent(short key, int ifAbsent) {
        int index = this.mask(key);
        for (int i = 0; i < 16; ++i) {
            short keyAtIndex = this.keys[index];
            if (keyAtIndex == key) {
                return this.values[index];
            }
            if (keyAtIndex == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private int slowGetIfAbsentTwo(short key, int ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public int getOrThrow(short key) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ShortIntHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(short key) {
        if (ShortIntHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ShortIntHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    @Override
    public void forEachKeyValue(ShortIntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    @Override
    public LazyShortIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ShortIntPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableIntShortMap flipUniqueValues() {
        MutableIntShortMap result = IntShortMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    @Override
    public ShortIntHashMap select(ShortIntPredicate predicate) {
        ShortIntHashMap result = new ShortIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public ShortIntHashMap reject(ShortIntPredicate predicate) {
        ShortIntHashMap result = new ShortIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeShort(0);
                out.writeInt(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeShort(1);
                out.writeInt(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortIntHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeShort(this.keys[i]);
            out.writeInt(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readShort(), in.readInt());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        short[] old = this.keys;
        int[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ShortIntHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(short element) {
        int index = this.mask(element);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 1; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(short element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            short keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(short element, int removedIndex) {
        int nextIndex = SpreadFunctions.shortSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.shortSpreadTwo(element)) | 1;
        short keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(short element) {
        int code = SpreadFunctions.shortSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(short element) {
        int code = SpreadFunctions.shortSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new short[sizeToAllocate];
        this.values = new int[sizeToAllocate];
    }

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !ShortIntHashMap.isEmptyKey(key) && !ShortIntHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !ShortIntHashMap.isEmptyKey(this.keys[index]) && !ShortIntHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    @Override
    public MutableShortSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableIntCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ short[] access$302(ShortIntHashMap x0, short[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(ShortIntHashMap x0, int[] x1) {
        x0.values = x1;
        return x1;
    }

    private class InternalIntIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private short lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalIntIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ShortIntHashMap.this.size();
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortIntHashMap.this.containsKey((short)0)) {
                    this.lastKey = 0;
                    return ShortIntHashMap.this.get((short)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortIntHashMap.this.containsKey((short)1)) {
                    this.lastKey = 1;
                    return ShortIntHashMap.this.get((short)1);
                }
            }
            short[] keys = ShortIntHashMap.this.keys;
            while (!ShortIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            int result = ShortIntHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ShortIntHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeySet
    extends AbstractMutableShortKeySet {
        private KeySet() {
        }

        @Override
        protected MutableShortKeysMap getOuter() {
            return ShortIntHashMap.this;
        }

        @Override
        protected AbstractMutableIntValuesMap.SentinelValues getSentinelValues() {
            return ShortIntHashMap.this.sentinelValues;
        }

        @Override
        protected short getKeyAtIndex(int index) {
            return ShortIntHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return ShortIntHashMap.this.keys.length;
        }

        @Override
        public MutableShortIterator shortIterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean retainAll(ShortIterable source) {
            int oldSize = ShortIntHashMap.this.size();
            ShortSet sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            ShortIntHashMap retained = ShortIntHashMap.this.select((short key, int value) -> sourceSet.contains(key));
            if (retained.size() != oldSize) {
                ShortIntHashMap.access$302(ShortIntHashMap.this, retained.keys);
                ShortIntHashMap.access$502(ShortIntHashMap.this, retained.values);
                ShortIntHashMap.this.sentinelValues = retained.sentinelValues;
                ShortIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(short ... source) {
            return this.retainAll(ShortHashSet.newSetWith(source));
        }

        @Override
        public ShortSet freeze() {
            ShortIntHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (ShortIntHashMap.this.sentinelValues != null) {
                containsZeroKey = ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableShortMapKeySet(ShortIntHashMap.this.keys, ShortIntHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public MutableShortSet newEmpty() {
            return new ShortHashSet();
        }
    }

    private class KeySetIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private short lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ShortIntHashMap.this.size();
        }

        @Override
        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortIntHashMap.this.containsKey((short)0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortIntHashMap.this.containsKey((short)1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            short[] keys = ShortIntHashMap.this.keys;
            while (!ShortIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ShortIntHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ShortIntPair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ShortIntPair> procedure) {
            if (ShortIntHashMap.this.sentinelValues != null) {
                if (((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair((short)0, ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.zeroValue));
                }
                if (((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair((short)1, ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ShortIntHashMap.this.keys.length; ++i) {
                if (!ShortIntHashMap.isNonSentinel(ShortIntHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ShortIntHashMap.this.keys[i], ShortIntHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ShortIntPair> objectIntProcedure) {
            int index = 0;
            if (ShortIntHashMap.this.sentinelValues != null) {
                if (((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair((short)0, ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair((short)1, ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ShortIntHashMap.this.keys.length; ++i) {
                if (!ShortIntHashMap.isNonSentinel(ShortIntHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ShortIntHashMap.this.keys[i], ShortIntHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ShortIntPair, ? super P> procedure, P parameter) {
            if (ShortIntHashMap.this.sentinelValues != null) {
                if (((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair((short)0, ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair((short)1, ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ShortIntHashMap.this.keys.length; ++i) {
                if (!ShortIntHashMap.isNonSentinel(ShortIntHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ShortIntHashMap.this.keys[i], ShortIntHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<ShortIntPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ShortIntPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ShortIntPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ShortIntHashMap.this.containsKey((short)0)) {
                        return PrimitiveTuples.pair((short)0, ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ShortIntHashMap.this.containsKey((short)1)) {
                        return PrimitiveTuples.pair((short)1, ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.oneValue);
                    }
                }
                short[] keys = ShortIntHashMap.this.keys;
                while (!ShortIntHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ShortIntPair result = PrimitiveTuples.pair(keys[this.position], ShortIntHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ShortIntHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyShortIterable {
        private KeysView() {
        }

        @Override
        public ShortIterator shortIterator() {
            return new UnmodifiableShortIterator(new KeySetIterator());
        }

        @Override
        public void each(ShortProcedure procedure) {
            ShortIntHashMap.this.forEachKey(procedure);
        }
    }

    private class ValuesCollection
    extends AbstractMutableIntValuesMap.AbstractIntValuesCollection {
        private ValuesCollection() {
        }

        @Override
        public MutableIntIterator intIterator() {
            return ShortIntHashMap.this.intIterator();
        }

        @Override
        public boolean remove(int item) {
            int oldSize = ShortIntHashMap.this.size();
            if (ShortIntHashMap.this.sentinelValues != null && ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsZeroKey && item == ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.zeroValue) {
                ShortIntHashMap.this.removeKey((short)0);
            }
            if (ShortIntHashMap.this.sentinelValues != null && ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.containsOneKey && item == ((ShortIntHashMap)ShortIntHashMap.this).sentinelValues.oneValue) {
                ShortIntHashMap.this.removeKey((short)1);
            }
            for (int i = 0; i < ShortIntHashMap.this.keys.length; ++i) {
                if (!ShortIntHashMap.isNonSentinel(ShortIntHashMap.this.keys[i]) || item != ShortIntHashMap.this.values[i]) continue;
                ShortIntHashMap.this.removeKey(ShortIntHashMap.this.keys[i]);
            }
            return oldSize != ShortIntHashMap.this.size();
        }

        @Override
        public boolean retainAll(IntIterable source) {
            int oldSize = ShortIntHashMap.this.size();
            IntSet sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            ShortIntHashMap retained = ShortIntHashMap.this.select((short key, int value) -> sourceSet.contains(value));
            if (retained.size() != oldSize) {
                ShortIntHashMap.access$302(ShortIntHashMap.this, retained.keys);
                ShortIntHashMap.access$502(ShortIntHashMap.this, retained.values);
                ShortIntHashMap.this.sentinelValues = retained.sentinelValues;
                ShortIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public MutableIntCollection newEmpty() {
            return new IntHashBag();
        }
    }
}

