/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.map.primitive.MutableIntObjectMapFactory;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableIntObjectMapFactoryImpl implements MutableIntObjectMapFactory
{
    INSTANCE;


    @Override
    public <V> MutableIntObjectMap<V> empty() {
        return new IntObjectHashMap(0);
    }

    @Override
    public <V> MutableIntObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> MutableIntObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> MutableIntObjectMap<V> ofAll(IntObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    @Override
    public <V> MutableIntObjectMap<V> withAll(IntObjectMap<? extends V> map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new IntObjectHashMap<V>(map);
    }

    @Override
    public <T, V> MutableIntObjectMap<V> from(Iterable<T> iterable, IntFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableIntObjectMap map = IntObjectMaps.mutable.empty();
        Iterate.forEach(iterable, each -> map.put(keyFunction.intValueOf(each), valueFunction.valueOf(each)));
        return map;
    }
}

