/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TargetURLDialog
extends Dialog {
    private final AbstractCloudFoundryUrl cloudUrl;
    private final String wildcard;
    private String value;
    private String name;
    private String url;
    private Text wildcardText;
    private Text nameText;
    private final List<AbstractCloudFoundryUrl> allCloudUrls;

    public TargetURLDialog(Shell parentShell, CloudFoundryBrandingExtensionPoint.CloudServerURL cloudUrl, String wildcard, List<CloudFoundryBrandingExtensionPoint.CloudServerURL> allCloudUrls) {
        super(parentShell);
        this.cloudUrl = cloudUrl;
        this.wildcard = wildcard;
        this.allCloudUrls = new ArrayList<AbstractCloudFoundryUrl>();
        int i = 0;
        while (i < allCloudUrls.size()) {
            this.allCloudUrls.add((AbstractCloudFoundryUrl)allCloudUrls.get(i));
            ++i;
        }
        this.url = cloudUrl.getUrl();
    }

    public TargetURLDialog(Shell parentShell, AbstractCloudFoundryUrl cloudUrl, String wildcard, List<AbstractCloudFoundryUrl> allCloudUrls) {
        super(parentShell);
        this.cloudUrl = cloudUrl;
        this.wildcard = wildcard;
        this.allCloudUrls = allCloudUrls;
        this.url = cloudUrl.getUrl();
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(NLS.bind((String)Messages.TargetURLDialog_TEXT_CREATE_DIALOG_SHELL, (Object)this.cloudUrl.getName()));
        Composite control = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(control, 0);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Label wildcardLabel = new Label(composite, 0);
        wildcardLabel.setText(NLS.bind((String)Messages.TargetURLDialog_TEXT_WILDCARD_LABEL, (Object)this.wildcard));
        GridDataFactory.fillDefaults().align(4, 4).hint(300, -1).applyTo((Control)wildcardLabel);
        this.wildcardText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.wildcardText);
        this.wildcardText.setEnabled(true);
        this.wildcardText.setText(this.wildcard);
        this.value = this.wildcard;
        this.wildcardText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TargetURLDialog.this.nameText.getText().equals(String.valueOf(TargetURLDialog.this.cloudUrl.getName()) + " (" + TargetURLDialog.this.value + ")")) {
                    TargetURLDialog.this.nameText.setText(String.valueOf(TargetURLDialog.this.cloudUrl.getName()) + " (" + TargetURLDialog.this.wildcardText.getText() + ")");
                }
                TargetURLDialog.this.value = TargetURLDialog.this.wildcardText.getText();
            }
        });
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.TargetURLDialog_TEXT_NAMELABEL);
        GridDataFactory.fillDefaults().align(4, 4).indent(0, 5).applyTo((Control)nameLabel);
        this.nameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.nameText);
        this.nameText.setEnabled(true);
        this.name = String.valueOf(this.cloudUrl.getName()) + " (" + this.value + ")";
        this.nameText.setText(this.name);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetURLDialog.this.name = TargetURLDialog.this.nameText.getText();
            }
        });
        return control;
    }

    protected void okPressed() {
        for (AbstractCloudFoundryUrl url : this.allCloudUrls) {
            if (!url.getName().equals(this.name)) continue;
            MessageDialog.openError((Shell)this.getParentShell(), (String)Messages.TargetURLDialog_ERROR_DUPLICATE_TITLE, (String)NLS.bind((String)Messages.TargetURLDialog_ERROR_DUPLICATE_BODY, (Object)this.name));
            return;
        }
        final boolean[] shouldProceed = new boolean[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TargetURLDialog.this.url = TargetURLDialog.replaceWildcard(TargetURLDialog.this.cloudUrl.getUrl(), TargetURLDialog.this.wildcard, TargetURLDialog.this.value);
                try {
                    CloudFoundryPlugin.getCloudFoundryClientFactory().getCloudFoundryOperations(TargetURLDialog.this.url).getCloudInfo();
                    shouldProceed[0] = true;
                }
                catch (Exception exception) {
                    shouldProceed[0] = MessageDialog.openQuestion((Shell)TargetURLDialog.this.getParentShell(), (String)Messages.TargetURLDialog_ERROR_INVALID_URL_TITLE, (String)NLS.bind((String)Messages.TargetURLDialog_ERROR_INVALID_URL_BODY, (Object)TargetURLDialog.this.url));
                }
            }
        });
        if (shouldProceed[0]) {
            super.okPressed();
        }
    }

    private static String replaceWildcard(String url, String wildcard, String value) {
        return url.replaceAll("\\{" + wildcard + "\\}", value);
    }
}

