/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.application.ModuleChangeEvent;
import org.eclipse.cft.server.core.internal.client.AbstractPublishApplicationOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;

class StopApplicationOperation
extends AbstractPublishApplicationOperation {
    protected StopApplicationOperation(CloudFoundryServerBehaviour behaviour, IModule[] modules) {
        super(behaviour, modules);
    }

    @Override
    public String getOperationName() {
        return Messages.StopApplicationOperation_STOPPING_APP;
    }

    @Override
    protected void doApplicationOperation(IProgressMonitor monitor) throws CoreException {
        Server server = (Server)this.getBehaviour().getServer();
        boolean succeeded = false;
        try {
            server.setModuleState(this.getModules(), 3);
            CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
            CloudFoundryApplicationModule cloudModule = cloudServer.getExistingCloudModule(this.getModule());
            if (cloudModule == null) {
                throw CloudErrorUtil.toCoreException("Unable to stop application as no cloud module found for: " + this.getModules()[0].getName());
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            String stoppingApplicationMessage = NLS.bind((String)Messages.CONSOLE_STOPPING_APPLICATION, (Object)cloudModule.getDeployedApplicationName());
            this.getBehaviour().clearAndPrintlnConsole(cloudModule, stoppingApplicationMessage);
            subMonitor.worked(20);
            this.getBehaviour().getRequestFactory().stopApplication(stoppingApplicationMessage, cloudModule).run((IProgressMonitor)subMonitor.newChild(20));
            server.setModuleState(this.getModules(), 4);
            succeeded = true;
            ServerEventHandler.getDefault().fireServerEvent(new ModuleChangeEvent(this.getBehaviour().getCloudFoundryServer(), 425, cloudModule.getLocalModule(), Status.OK_STATUS));
            this.getBehaviour().updateModuleWithAllCloudInfo(cloudModule.getDeployedApplicationName(), (IProgressMonitor)subMonitor.newChild(40));
            this.getBehaviour().printlnToConsole(cloudModule, Messages.CONSOLE_APP_STOPPED);
            CloudFoundryPlugin.getCallback().stopApplicationConsole(cloudModule, cloudServer);
            subMonitor.worked(20);
        }
        finally {
            if (!succeeded) {
                server.setModuleState(this.getModules(), 0);
            }
        }
    }
}

