/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ValueValidationUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.eclipse.wst.server.core.util.PublishHelper;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class CloudUtil {
    public static final int DEFAULT_MEMORY = 512;
    private static final IStatus[] EMPTY_STATUS = new IStatus[0];
    private static final int BUFFER = 65536;
    private static byte[] buf = new byte[65536];

    public static IWebModule getWebModule(IModule[] modules) {
        IModuleType moduleType = modules[0].getModuleType();
        if (modules.length == 1 && moduleType != null && "jst.web".equals(moduleType.getId())) {
            return (IWebModule)modules[0].loadAdapter(IWebModule.class, null);
        }
        return null;
    }

    public static File createWarFile(List<IModuleResource> allResources, IModule module, Set<IModuleResource> filterInResources, IProgressMonitor monitor) throws CoreException {
        if (allResources == null || allResources.isEmpty() || filterInResources == null || filterInResources.isEmpty()) {
            return null;
        }
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        try {
            File tempDirectory = CloudUtil.getTempFolder(module);
            String fileName = String.valueOf(module.getName()) + ".war";
            File warFile = new File(tempDirectory, fileName);
            warFile.createNewFile();
            warFile.deleteOnExit();
            ArrayList<IModuleResource> newResources = new ArrayList<IModuleResource>();
            for (IModuleResource mr : allResources) {
                newResources.add(CloudUtil.processModuleResource(mr));
            }
            IStatus[] status = CloudUtil.publishZip(allResources, warFile, filterInResources, monitor);
            CloudUtil.merge(result, status);
            CloudUtil.throwException(result, "Publishing of : " + module.getName() + " failed");
            return warFile;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", "Failed to create war file: " + e.getMessage(), (Throwable)e));
        }
    }

    public static File createWarFile(IModule[] modules, Server server, IProgressMonitor monitor) throws CoreException {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        try {
            IModule[] children;
            File tempFile = CloudUtil.getTempFolder(modules[0]);
            File targetFile = new File(tempFile, String.valueOf(modules[0].getName()) + ".war");
            targetFile.deleteOnExit();
            PublishHelper helper = new PublishHelper(tempFile);
            ArrayList<IModuleResource> resources = new ArrayList<IModuleResource>(Arrays.asList(server.getResources(modules)));
            IWebModule webModule = CloudUtil.getWebModule(modules);
            if (webModule != null && (children = webModule.getModules()) != null) {
                IModule[] iModuleArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus[] status;
                    IModuleResource[] mr;
                    File jarFile;
                    Path jarPath;
                    IModule child = iModuleArray[n2];
                    String childUri = null;
                    if (webModule != null) {
                        childUri = webModule.getURI(child);
                    }
                    IJ2EEModule childModule = (IJ2EEModule)child.loadAdapter(IJ2EEModule.class, monitor);
                    boolean isBinary = false;
                    if (childModule != null) {
                        isBinary = childModule.isBinary();
                    }
                    if (isBinary) {
                        if (childUri == null) {
                            childUri = "WEB-INF/lib/" + child.getName();
                        }
                        jarPath = new Path(childUri);
                        jarFile = new File(tempFile, jarPath.lastSegment());
                        jarPath = jarPath.removeLastSegments(1);
                        mr = server.getResources(new IModule[]{child});
                        status = helper.publishToPath(mr, (IPath)new Path(jarFile.getAbsolutePath()), monitor);
                        CloudUtil.merge(result, status);
                        resources.add((IModuleResource)new ModuleFile(jarFile, jarFile.getName(), (IPath)jarPath));
                    } else {
                        if (childUri == null) {
                            childUri = "WEB-INF/lib/" + child.getName() + ".jar";
                        }
                        jarPath = new Path(childUri);
                        jarFile = new File(tempFile, jarPath.lastSegment());
                        jarPath = jarPath.removeLastSegments(1);
                        mr = server.getResources(new IModule[]{child});
                        status = helper.publishZip(mr, (IPath)new Path(jarFile.getAbsolutePath()), monitor);
                        CloudUtil.merge(result, status);
                        resources.add((IModuleResource)new ModuleFile(jarFile, jarFile.getName(), (IPath)jarPath));
                    }
                    ++n2;
                }
            }
            ArrayList<IModuleResource> newResources = new ArrayList<IModuleResource>();
            for (IModuleResource mr : resources) {
                newResources.add(CloudUtil.processModuleResource(mr));
            }
            IStatus[] status = helper.publishZip(newResources.toArray(new IModuleResource[0]), (IPath)new Path(targetFile.getAbsolutePath()), monitor);
            CloudUtil.merge(result, status);
            CloudUtil.throwException(result, "Publishing of " + modules[0].getName() + " failed");
            return targetFile;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", "Failed to create war file: " + e.getMessage(), (Throwable)e));
        }
    }

    private static IModuleResource processModuleResource(IModuleResource or) {
        if (or instanceof IModuleFolder) {
            IModuleFolder of = (IModuleFolder)or;
            IPath p = of.getModuleRelativePath();
            if (p.isAbsolute()) {
                p = p.makeRelative();
            }
            ModuleFolder nf = new ModuleFolder(null, of.getName(), p);
            ArrayList<IModuleResource> c = new ArrayList<IModuleResource>();
            IModuleResource[] iModuleResourceArray = of.members();
            int n = iModuleResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleResource mc = iModuleResourceArray[n2];
                c.add(CloudUtil.processModuleResource(mc));
                ++n2;
            }
            nf.setMembers(c.toArray(new IModuleResource[0]));
            return nf;
        }
        return or;
    }

    private static File getTempFolder(IModule module) throws IOException {
        File tempFile = File.createTempFile("tempFileForWar", null);
        tempFile.delete();
        tempFile.mkdirs();
        return tempFile;
    }

    protected static void throwException(List<IStatus> status, String message) throws CoreException {
        if (status == null || status.size() == 0) {
            return;
        }
        throw new CoreException((IStatus)new MultiStatus("org.eclipse.cft.server.core", 0, status.toArray(new IStatus[0]), message, null));
    }

    public static IStatus[] publishZip(List<IModuleResource> allResources, File tempFile, Set<IModuleResource> filterInFiles, IProgressMonitor monitor) {
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        try {
            try {
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(tempFile));
                ZipOutputStream zout = new ZipOutputStream(bout);
                CloudUtil.addZipEntries(zout, allResources, filterInFiles);
                zout.close();
            }
            catch (CoreException e) {
                IStatus[] iStatusArray = new IStatus[]{e.getStatus()};
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                return iStatusArray;
            }
            catch (Exception e) {
                Status[] statusArray = new Status[]{new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.ERROR_CREATE_ZIP, (Object)tempFile.getName(), (Object)e.getLocalizedMessage()), (Throwable)e)};
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                return statusArray;
            }
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
        }
        return EMPTY_STATUS;
    }

    public static String getZipRelativeName(IModuleResource resource) {
        IPath path = resource.getModuleRelativePath().append(resource.getName());
        String entryPath = path.toPortableString();
        if (resource instanceof IModuleFolder && !entryPath.endsWith("/")) {
            entryPath = String.valueOf(entryPath) + '/';
        }
        return entryPath;
    }

    private static void addZipEntries(ZipOutputStream out, List<IModuleResource> allResources, Set<IModuleResource> filterInFiles) throws Exception {
        if (allResources == null) {
            return;
        }
        for (IModuleResource resource : allResources) {
            ZipEntry zipEntry;
            String entryPath;
            if (resource instanceof IModuleFolder) {
                IModuleResource[] folderResources = ((IModuleFolder)resource).members();
                entryPath = CloudUtil.getZipRelativeName(resource);
                zipEntry = new ZipEntry(entryPath);
                long timeStamp = 0L;
                IContainer folder = (IContainer)resource.getAdapter(IContainer.class);
                if (folder != null) {
                    timeStamp = folder.getLocalTimeStamp();
                }
                if (timeStamp != -1L && timeStamp != 0L) {
                    zipEntry.setTime(timeStamp);
                }
                out.putNextEntry(zipEntry);
                out.closeEntry();
                CloudUtil.addZipEntries(out, Arrays.asList(folderResources), filterInFiles);
                continue;
            }
            IModuleFile moduleFile = (IModuleFile)resource;
            if (!filterInFiles.contains(moduleFile)) continue;
            entryPath = CloudUtil.getZipRelativeName(resource);
            zipEntry = new ZipEntry(entryPath);
            InputStream input = null;
            long timeStamp = 0L;
            IFile iFile = (IFile)moduleFile.getAdapter(IFile.class);
            if (iFile != null) {
                timeStamp = iFile.getLocalTimeStamp();
                input = iFile.getContents();
            } else {
                File file = (File)moduleFile.getAdapter(File.class);
                timeStamp = file.lastModified();
                input = new FileInputStream(file);
            }
            if (timeStamp != -1L && timeStamp != 0L) {
                zipEntry.setTime(timeStamp);
            }
            out.putNextEntry(zipEntry);
            try {
                int n = 0;
                while (n > -1) {
                    n = input.read(buf);
                    if (n <= 0) continue;
                    out.write(buf, 0, n);
                }
            }
            finally {
                input.close();
            }
            out.closeEntry();
        }
    }

    public static File createTemporaryFile(String folderName, String fileName) throws IOException {
        File tempFolder = File.createTempFile(folderName, null);
        tempFolder.delete();
        tempFolder.mkdirs();
        tempFolder.setExecutable(true);
        File targetFile = new File(tempFolder, fileName);
        targetFile.delete();
        targetFile.createNewFile();
        targetFile.setExecutable(true);
        targetFile.setWritable(true);
        return targetFile;
    }

    public static void merge(List<IStatus> result, IStatus[] status) {
        if (result == null || status == null || status.length == 0) {
            return;
        }
        int size = status.length;
        int i = 0;
        while (i < size) {
            result.add(status[i]);
            ++i;
        }
    }

    public static IStatus basicValidateDeploymentInfo(ApplicationDeploymentInfo deploymentInfo) {
        IStatus status = Status.OK_STATUS;
        String errorMessage = null;
        if (deploymentInfo == null) {
            errorMessage = Messages.AbstractApplicationDelegate_ERROR_MISSING_DEPLOY_INFO;
        } else if (ValueValidationUtil.isEmpty(deploymentInfo.getDeploymentName())) {
            errorMessage = Messages.AbstractApplicationDelegate_ERROR_MISSING_APPNAME;
        } else if (deploymentInfo.getMemory() <= 0) {
            errorMessage = Messages.AbstractApplicationDelegate_ERROR_MISSING_MEM;
        }
        if (errorMessage != null) {
            status = CloudFoundryPlugin.getErrorStatus(errorMessage);
        }
        return status;
    }

    public static ApplicationDeploymentInfo parseApplicationDeploymentInfo(CloudApplication cloudApplication) {
        if (cloudApplication != null) {
            Map envMap;
            String deploymentName = cloudApplication.getName();
            ApplicationDeploymentInfo deploymentInfo = new ApplicationDeploymentInfo(deploymentName);
            deploymentInfo.setInstances(cloudApplication.getInstances());
            if (cloudApplication.getStaging() != null) {
                deploymentInfo.setBuildpack(cloudApplication.getStaging().getBuildpackUrl());
            }
            deploymentInfo.setMemory(cloudApplication.getMemory());
            List boundServiceNames = cloudApplication.getServices();
            if (boundServiceNames != null) {
                ArrayList<CFServiceInstance> services = new ArrayList<CFServiceInstance>();
                for (String name : boundServiceNames) {
                    if (name == null) continue;
                    services.add(new CFServiceInstance(name));
                }
                deploymentInfo.setServices(services);
            }
            if (cloudApplication.getUris() != null) {
                deploymentInfo.setUris(new ArrayList<String>(cloudApplication.getUris()));
            }
            if ((envMap = cloudApplication.getEnvAsMap()) != null) {
                ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>();
                for (Map.Entry entry : envMap.entrySet()) {
                    String varName = (String)entry.getKey();
                    if (varName == null) continue;
                    EnvironmentVariable variable = new EnvironmentVariable();
                    variable.setVariable(varName);
                    variable.setValue((String)entry.getValue());
                    variables.add(variable);
                }
                deploymentInfo.setEnvVariables(variables);
            }
            return deploymentInfo;
        }
        return null;
    }

    public static CloudCredentials createSsoCredentials(String passcode, String tokenValue) {
        CloudCredentials credentials = null;
        if (tokenValue != null && !tokenValue.isEmpty()) {
            try {
                OAuth2AccessToken token = CloudUtil.getTokenAsOAuth2Access(tokenValue);
                credentials = new CloudCredentials(passcode, token);
            }
            catch (IOException iOException) {}
        }
        if (credentials == null) {
            credentials = new CloudCredentials(passcode);
        }
        return credentials;
    }

    public static OAuth2AccessToken getTokenAsOAuth2Access(String authToken) throws IOException {
        return (OAuth2AccessToken)new ObjectMapper().readValue(authToken, OAuth2AccessToken.class);
    }

    public static String getTokenAsJson(OAuth2AccessToken token) throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString((Object)token);
    }
}

