/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.matrix.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleCheckArtifactExistenceHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ToggleCheckArtifactExistenceHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
        ToggleCheckArtifactExistenceHandler.checkArtifaceExistence(!oldValue);
        return null;
    }

    public static boolean checkArtifaceExistence() {
        Preferences internalLinks = ToggleCheckArtifactExistenceHandler.getPreference();
        return internalLinks.getBoolean("option", false);
    }

    private static Preferences getPreference() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.capra.ui.matrix");
        return preferences.node("checkArtifactExistence");
    }

    public static void checkArtifaceExistence(boolean value) {
        Preferences preference = ToggleCheckArtifactExistenceHandler.getPreference();
        preference.putBoolean("option", value);
        try {
            preference.flush();
        }
        catch (BackingStoreException e) {
            LOG.warn("Could not save internal links preferences!", (Throwable)e);
        }
    }
}

