/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.polarsys.capella.docgen.util.DefaultImageHandler;
import org.polarsys.capella.docgen.util.StringUtil;

public class CDOImageHandler
extends DefaultImageHandler {
    @Override
    public boolean isHandlerFor(String uri) {
        return uri.startsWith("cdo");
    }

    @Override
    public String handleImage(ILog logger, EObject eObject, String imageSrc, IFolder parentTargetFolder, List<String> imageFileNames) {
        Session session = new EObjectQuery(eObject).getSession();
        String decodedImageSrc = StringUtil.decodeHtmlFilePath(imageSrc, logger);
        if (decodedImageSrc == null) {
            return null;
        }
        Path patha = new Path(decodedImageSrc);
        String id = this.getID(eObject);
        String targetIconPath = this.getTargetIconPath((IPath)patha, id, imageFileNames);
        targetIconPath = StringUtil.unencodeURIString(targetIconPath, logger);
        File imageFile = FileProvider.getDefault().getFile((IPath)new Path(imageSrc), (Object)session);
        if (imageFile != null) {
            this.copyImage(logger, eObject, imageFile.getAbsolutePath(), parentTargetFolder, targetIconPath);
        }
        return targetIconPath;
    }
}

