/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.types.Type;
import org.eclipse.egf.model.types.TypeString;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.docgen.configuration.ui.Activator;
import org.polarsys.capella.docgen.configuration.ui.Messages;
import org.polarsys.capella.docgen.configuration.ui.wizard.SelectElementsWizardPage;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeElementStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeException;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeReferencesStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.ui.helper.InvokeActivityHelper;
import org.polarsys.kitalpha.doc.gen.business.core.ui.wizards.HTMLDocumentationBrandingWizardPage;
import org.polarsys.kitalpha.doc.gen.business.core.ui.wizards.HTMLDocumentationGenerationWizard;
import org.polarsys.kitalpha.doc.gen.business.core.ui.wizards.HTMLDocumentationGenerationWizardPage;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;

public class HTMLDocumentationConfigurationGenerationAction
extends BaseSelectionListenerAction {
    private static final URI CAPELLA_LAUNCHER_URI = URI.createURI((String)"platform:/plugin/org.polarsys.capella.docgen.ui/egf/capellalauncher.fcore#_zup7kAkdEeCBJtEcjZDVOA");
    private SelectElementsWizardPage selectElementsPage;
    private HTMLDocumentationGenerationWizardPage page;
    private HTMLDocumentationBrandingWizardPage brandingPage;

    public HTMLDocumentationConfigurationGenerationAction() {
        super(Messages.HTMLDocumentationConfigurationGenerationAction_1);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/ctool16/binary-16x16.png"));
    }

    protected HTMLDocumentationConfigurationGenerationAction(String text_p) {
        super(text_p);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/ctool16/binary-16x16.png"));
    }

    public void run() {
        final IStructuredSelection structuredSelection = this.getStructuredSelection();
        HTMLDocumentationGenerationWizard wizard = new HTMLDocumentationGenerationWizard(structuredSelection){

            protected Map<String, URI> getLaunchersURI() {
                IConfigurationElement[] config;
                HashMap<String, URI> map = new HashMap<String, URI>();
                map.put("Default Launcher", CAPELLA_LAUNCHER_URI);
                IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.capella.docgen.ui.launcher");
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    if (configurationElement.getName().equals("launcher")) {
                        String nameString = configurationElement.getAttribute("name");
                        String uriString = configurationElement.getAttribute("uri");
                        map.put(nameString, URI.createURI((String)uriString));
                    }
                    ++n2;
                }
                return map;
            }

            public void addPages() {
                HTMLDocumentationConfigurationGenerationAction.this.selectElementsPage = new SelectElementsWizardPage((ISelection)structuredSelection);
                this.addPage((IWizardPage)HTMLDocumentationConfigurationGenerationAction.this.selectElementsPage);
                super.addPages();
                HTMLDocumentationConfigurationGenerationAction.this.page = (HTMLDocumentationGenerationWizardPage)this.getPages()[1];
                HTMLDocumentationConfigurationGenerationAction.this.page.setScopedGeneration(true);
                HTMLDocumentationConfigurationGenerationAction.this.brandingPage = (HTMLDocumentationBrandingWizardPage)this.getPages()[2];
            }

            public boolean performFinish() {
                this.selectedModelElements.addAll(HTMLDocumentationConfigurationGenerationAction.this.selectElementsPage.getSelectedElements());
                HTMLDocumentationConfigurationGenerationAction.this.brandingPage.askUserForUpdatingBrandingDataPreferences();
                String modelURI = HTMLDocumentationConfigurationGenerationAction.this.page.getModelURI();
                String containerName = HTMLDocumentationConfigurationGenerationAction.this.page.getContainerName();
                String selectedLauncher = HTMLDocumentationConfigurationGenerationAction.this.page.getSelectedLauncher();
                String copyright = HTMLDocumentationConfigurationGenerationAction.this.brandingPage.getCopyright();
                String logoAlt = HTMLDocumentationConfigurationGenerationAction.this.brandingPage.getLogoAlt();
                String logoPath = HTMLDocumentationConfigurationGenerationAction.this.brandingPage.getLogoPath();
                this.initializeScope();
                LabelProviderHelper.initImageRegistry();
                List<URI> modelURIList = this.getURIList(modelURI);
                String projectName = this.getProjectName(containerName);
                String outputFolder = this.getOutputFolder(containerName);
                Activity melodyLauncher = InvokeActivityHelper.getActivity((URI)this.getLaunchersURI().get(selectedLauncher));
                Iterator<URI> iterator = modelURIList.iterator();
                while (iterator.hasNext()) {
                    URI uri;
                    URI semanticResourceURI = uri = iterator.next();
                    if (uri.lastSegment().endsWith(".aird")) {
                        DiagramSessionHelper.setAirdUri((URI)uri);
                        Session session = DiagramSessionHelper.initSession();
                        Collection resources = session.getSemanticResources();
                        if (!resources.isEmpty()) {
                            for (Resource next : resources) {
                                URI uri2 = next.getURI();
                                if (uri2.lastSegment().endsWith(".afm")) continue;
                                semanticResourceURI = uri2 == null ? semanticResourceURI : uri2;
                                break;
                            }
                        }
                    }
                    this.execute(melodyLauncher, projectName, outputFolder, semanticResourceURI, copyright, logoAlt, logoPath);
                }
                return true;
            }

            private void initializeScope() {
                GenerationGlobalScope.getInstance().cleanScope();
                GenerationGlobalScope.getInstance().setReferencesStrategy(HTMLDocumentationConfigurationGenerationAction.this.page.getReferencesStrategy());
                ReflectionHelper.setFieldValueWithoutException((Object)GenerationGlobalScope.getInstance(), (String)"elementStrategy", (Object)ScopeElementStrategy.ELEMENT);
                if (this.selectedModelElements != null && !this.selectedModelElements.isEmpty()) {
                    for (EObject eObject : this.selectedModelElements) {
                        try {
                            GenerationGlobalScope.getInstance().addToScope(eObject);
                        }
                        catch (ScopeException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            private List<URI> getURIList(String modelURI) {
                HashSet<URI> uriSet = new HashSet<URI>();
                StringTokenizer tokenizer = new StringTokenizer(modelURI);
                while (tokenizer.hasMoreElements()) {
                    String nextURI = tokenizer.nextElement().toString();
                    uriSet.add(URI.createURI((String)nextURI));
                }
                return new ArrayList<URI>(uriSet);
            }

            private String getOutputFolder(String containerName) {
                String projectName = this.getProjectName(containerName);
                Path outputFolderPath = new Path(containerName);
                outputFolderPath = outputFolderPath.makeRelativeTo((IPath)new Path(projectName));
                return outputFolderPath.toString();
            }

            private String getProjectName(String containerName) {
                IFolder container = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(containerName));
                return container.getProject().getName();
            }

            private void execute(Activity melodyLauncher, String projectName, String outputFolder, URI uri, String copyright, String logoAlt, String logoPath) {
                Path path = new Path(String.valueOf(projectName) + "/" + outputFolder);
                path = path.append("output");
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                if (!folder.exists()) {
                    try {
                        folder.create(true, true, null);
                    }
                    catch (CoreException e) {
                        EGFPatternPlugin.getDefault().logError((Throwable)e);
                    }
                }
                if (melodyLauncher instanceof FactoryComponent) {
                    FactoryComponent factoryComponent = (FactoryComponent)melodyLauncher;
                    this.setContract(factoryComponent, "projectName", projectName, true);
                    this.setContract(factoryComponent, "outputFolder", String.valueOf(outputFolder) + "/output", true);
                    this.setDomain(factoryComponent, uri);
                    this.setContract(factoryComponent, "copyright", copyright, false);
                    this.setContract(factoryComponent, "logo.alt", logoAlt, false);
                    this.setContract(factoryComponent, "logo.path", logoPath, false);
                    try {
                        InvokeActivityHelper.invoke((Activity)factoryComponent);
                    }
                    catch (Exception e) {
                        EGFPatternPlugin.getDefault().logError((Throwable)e);
                    }
                }
            }

            private void setContract(FactoryComponent factoryComponent, String contractName, String value, boolean mandatory) {
                Contract invokedContract = factoryComponent.getContract(contractName);
                if (invokedContract != null) {
                    Type type = invokedContract.getType();
                    if (type instanceof TypeString) {
                        TypeString typeString = (TypeString)type;
                        typeString.setValue(value);
                    }
                } else if (mandatory) {
                    throw new IllegalArgumentException("Can't find the mandatory contract " + contractName + " in the factory component " + factoryComponent.getName());
                }
            }

            private void setDomain(FactoryComponent factoryComponent, URI uri) {
                DomainViewpoint domainViewpoint;
                Domain domain;
                Viewpoint viewpoint = factoryComponent.getViewpointContainer().getViewpoint(DomainViewpoint.class);
                if (viewpoint instanceof DomainViewpoint && (domain = (Domain)(domainViewpoint = (DomainViewpoint)viewpoint).getDomains().get(0)) instanceof EMFDomain) {
                    EMFDomain domainURI = (EMFDomain)domain;
                    domainURI.setUri(uri);
                }
            }
        };
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setSize(800, 600);
            }

            protected Control createContents(Composite parent) {
                Group group;
                Control createContents = super.createContents(parent);
                Control control = HTMLDocumentationConfigurationGenerationAction.this.page.getControl();
                if (control instanceof Composite && ((Composite)control).getChildren().length == 7 && ((Composite)control).getChildren()[6] instanceof Group && (group = (Group)((Composite)control).getChildren()[6]).getChildren().length == 1 && group.getChildren()[0] instanceof Button) {
                    Button button = (Button)group.getChildren()[0];
                    button.setSelection(false);
                    ReflectionHelper.setFieldValueWithoutException((Object)HTMLDocumentationConfigurationGenerationAction.this.page, (String)"referencesStrategy", (Object)ScopeReferencesStrategy.DONT_EXPORT);
                }
                return createContents;
            }

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                return super.createButton(parent, id, label, false);
            }

            public void updateButtons() {
                super.updateButtons();
                this.getShell().setDefaultButton(null);
                this.getShell().setDefaultButton(null);
            }
        };
        dialog.open();
    }

    public void updateSatus() {
        boolean enable = false;
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        Object element = structuredSelection.getFirstElement();
        if (element instanceof IResource) {
            URI uri = URI.createPlatformResourceURI((String)((IResource)element).getFullPath().toString(), (boolean)true);
            for (Session currentSession : SessionManager.INSTANCE.getSessions()) {
                if (currentSession.getSessionResource() == null || !currentSession.getSessionResource().getURI().equals(uri)) continue;
                enable = true;
            }
            this.setEnabled(enable);
        }
    }
}

