/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.fastzipfilereader;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import nonapi.io.github.classgraph.concurrency.SingletonMap;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;

class PhysicalZipFile
implements Closeable {
    private final File file;
    private final String path;
    private RandomAccessFile raf;
    private FileChannel fc;
    final long fileLen;
    final int numMappedByteBuffers;
    private ByteBuffer[] mappedByteBuffersCached;
    private SingletonMap<Integer, ByteBuffer, IOException> chunkIdxToByteBuffer;
    NestedJarHandler nestedJarHandler;
    boolean isDeflatedToRam;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    PhysicalZipFile(File file, NestedJarHandler nestedJarHandler) throws IOException {
        FileUtils.checkCanReadAndIsFile(file);
        this.file = file;
        this.nestedJarHandler = nestedJarHandler;
        this.path = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, file.getPath());
        try {
            this.raf = new RandomAccessFile(file, "r");
            this.fileLen = this.raf.length();
            if (this.fileLen == 0L) {
                throw new IOException("Zipfile is empty: " + file);
            }
            this.fc = this.raf.getChannel();
        }
        catch (IOException | SecurityException e) {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
            if (this.fc != null) {
                this.fc.close();
                this.fc = null;
            }
            throw e;
        }
        this.numMappedByteBuffers = (int)((this.fileLen + 0x7FFFFFF7L) / 0x7FFFFFF7L);
        this.mappedByteBuffersCached = new MappedByteBuffer[this.numMappedByteBuffers];
        this.chunkIdxToByteBuffer = new SingletonMap<Integer, ByteBuffer, IOException>(){

            @Override
            public ByteBuffer newInstance(Integer chunkIdxI, LogNode log) throws IOException {
                long pos = chunkIdxI.longValue() * 0x7FFFFFF7L;
                long chunkSize = Math.min(0x7FFFFFF7L, PhysicalZipFile.this.fileLen - pos);
                MappedByteBuffer buffer = null;
                try {
                    buffer = PhysicalZipFile.this.fc.map(FileChannel.MapMode.READ_ONLY, pos, chunkSize);
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException | OutOfMemoryError e) {
                    System.gc();
                    buffer = PhysicalZipFile.this.fc.map(FileChannel.MapMode.READ_ONLY, pos, chunkSize);
                }
                return buffer;
            }
        };
    }

    PhysicalZipFile(ByteBuffer byteBuffer, File outermostFile, String path, NestedJarHandler nestedJarHandler) throws IOException {
        this.file = outermostFile;
        this.path = path;
        this.nestedJarHandler = nestedJarHandler;
        this.isDeflatedToRam = true;
        this.fileLen = byteBuffer.remaining();
        if (this.fileLen == 0L) {
            throw new IOException("Zipfile is empty: " + path);
        }
        this.numMappedByteBuffers = 1;
        this.mappedByteBuffersCached = new ByteBuffer[this.numMappedByteBuffers];
        this.mappedByteBuffersCached[0] = byteBuffer;
    }

    ByteBuffer getByteBuffer(int chunkIdx) throws IOException, InterruptedException {
        if (this.closed.get()) {
            throw new IOException(this.getClass().getSimpleName() + " already closed");
        }
        if (chunkIdx < 0 || chunkIdx >= this.mappedByteBuffersCached.length) {
            throw new IOException("Chunk index out of range");
        }
        if (this.mappedByteBuffersCached[chunkIdx] == null) {
            try {
                this.mappedByteBuffersCached[chunkIdx] = this.chunkIdxToByteBuffer.get(chunkIdx, null);
            }
            catch (SingletonMap.NullSingletonException e) {
                throw new IOException("Cannot get ByteBuffer chunk " + chunkIdx + " : " + e);
            }
        }
        return this.mappedByteBuffersCached[chunkIdx];
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.file == null ? 0 : this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PhysicalZipFile)) {
            return false;
        }
        return Objects.equals(this.file, ((PhysicalZipFile)obj).file);
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.fc != null) {
                try {
                    this.fc.close();
                    this.fc = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.raf != null) {
                try {
                    this.raf.close();
                    this.raf = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.chunkIdxToByteBuffer != null) {
                this.chunkIdxToByteBuffer.clear();
                this.chunkIdxToByteBuffer = null;
            }
            if (this.mappedByteBuffersCached != null) {
                for (int i = 0; i < this.mappedByteBuffersCached.length; ++i) {
                    if (this.mappedByteBuffersCached[i] == null) continue;
                    FileUtils.closeDirectByteBuffer(this.mappedByteBuffersCached[i], null);
                    this.mappedByteBuffersCached[i] = null;
                }
                this.mappedByteBuffersCached = null;
            }
            this.nestedJarHandler = null;
        }
    }

    public String toString() {
        return this.path;
    }
}

