/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.attachment;

import java.util.Objects;
import java.util.stream.Stream;
import org.polarsys.capella.core.model.helpers.graph.InvolvementHierarchyGraph;

public class Path {
    private final InvolvementHierarchyGraph.Element element;
    private final Path next;
    private int hash = -1;

    public Path(InvolvementHierarchyGraph.Element element) {
        this(element, null);
    }

    public Path(InvolvementHierarchyGraph.Element element, Path next) {
        this.element = element;
        this.next = next;
    }

    public Stream<InvolvementHierarchyGraph.Element> getAll() {
        if (this.next == null) {
            return Stream.of(this.element);
        }
        return Stream.concat(Stream.of(this.element), this.next.getAll());
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = Objects.hash(this.element, this.next);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        Path p = (Path)obj;
        if (!Objects.equals(this.element, p.element)) {
            return false;
        }
        return Objects.equals(this.next, p.next);
    }

    public static Path of(InvolvementHierarchyGraph.Element element) {
        return new Path(element);
    }

    public static Path combine(InvolvementHierarchyGraph.Element element, Path next) {
        return new Path(element, next);
    }

    public boolean contains(InvolvementHierarchyGraph.Element node) {
        return this.element.equals(node) || this.next != null && this.next.contains(node);
    }
}

