/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.transition.common.constants.IOptionsConstants;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.scope.CompoundScopeFilter;
import org.polarsys.capella.core.transition.common.handlers.scope.CompoundScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeFilter;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.traceability.CompoundTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ITraceabilityConfiguration;
import org.polarsys.capella.core.transition.system.handlers.attachment.CapellaDefaultAttachmentHandler;
import org.polarsys.capella.transition.system2subsystem.context.SubSystemContextHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.FunctionalChainAttachmentHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.PhysicalPathAttachmentHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.ScenarioAttachmentHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.scope.ExternalFunctionsScopeRetriever;
import org.polarsys.capella.transition.system2subsystem.handlers.scope.PropertyValuesScopeFilter;
import org.polarsys.capella.transition.system2subsystem.handlers.scope.PropertyValuesScopeRetriever;
import org.polarsys.capella.transition.system2subsystem.handlers.scope.RequirementsScopeFilter;
import org.polarsys.capella.transition.system2subsystem.handlers.scope.RequirementsScopeRetriever;
import org.polarsys.capella.transition.system2subsystem.handlers.scope.StatusScopeRetriever;
import org.polarsys.capella.transition.system2subsystem.handlers.session.SubSystemSessionHandler;
import org.polarsys.capella.transition.system2subsystem.handlers.traceability.config.TransformationConfiguration;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class InitializeTransitionActivity
extends org.polarsys.capella.core.transition.system.activities.InitializeTransitionActivity {
    public static final String ID = "org.polarsys.capella.transition.system2subsystem.activities.InitializeTransitionActivity";

    protected String getDefaultOptionsScope() {
        return "capella.core.transition.system2subsystem";
    }

    protected IStatus initializeScopeFilterHandlers(IContext context, CompoundScopeFilter handler, ActivityParameters activityParams) {
        Object filter = PropertyValuesScopeFilter.getInstance(context);
        handler.addScopeFilter((IScopeFilter)filter, context);
        filter = RequirementsScopeFilter.getInstance(context);
        handler.addScopeFilter((IScopeFilter)filter, context);
        return super.initializeScopeFilterHandlers(context, handler, activityParams);
    }

    protected Collection<EObject> adaptSelection(Collection<Object> selection) {
        Collection superCollection = super.adaptSelection(selection);
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object item : superCollection) {
            if (!(item instanceof EObject)) continue;
            if (item instanceof Part) {
                item = ((Part)item).getAbstractType();
            }
            result.add((EObject)item);
        }
        return result;
    }

    protected IStatus initializeScopeRetrieverHandlers(IContext context, CompoundScopeRetriever handler, ActivityParameters activityParams) {
        Object retriever = new PropertyValuesScopeRetriever();
        handler.addScopeRetriever((IScopeRetriever)retriever, context);
        retriever = new RequirementsScopeRetriever();
        handler.addScopeRetriever((IScopeRetriever)retriever, context);
        handler.addScopeRetriever((IScopeRetriever)new ExternalFunctionsScopeRetriever(), context);
        handler.addScopeRetriever((IScopeRetriever)new StatusScopeRetriever(), context);
        return super.initializeScopeRetrieverHandlers(context, handler, activityParams);
    }

    protected IStatus initializeContext(IContext context, ActivityParameters activityParams) {
        Object handler = new FunctionalChainAttachmentHelper();
        handler.init(context);
        context.put((Object)"FCAttachment", handler);
        handler = new PhysicalPathAttachmentHelper();
        handler.init(context);
        context.put((Object)"PPAttachment", handler);
        handler = new ScenarioAttachmentHelper();
        handler.init(context);
        context.put((Object)"Scenario_Attachment", handler);
        return super.initializeContext(context, activityParams);
    }

    protected IStatus initializeSource(IContext context, ActivityParameters activityParams) {
        Set<Resource> libraryResources;
        super.initializeSource(context, activityParams);
        Object sourceProject = context.get((Object)"_TSRo");
        if (sourceProject instanceof Project && (libraryResources = SubSystemContextHelper.getLibraryResources((Project)sourceProject)) != null && !libraryResources.isEmpty()) {
            context.put((Object)"RESOURCES_FOR_LIBRARIES_OF_SOURCE_PROJECT", libraryResources);
            context.put((Object)"ROOTS_FOR_LIBRARIES_OF_SOURCE_PROJECT", SubSystemContextHelper.getLibraryRoots(libraryResources));
        }
        return Status.OK_STATUS;
    }

    protected IStatus initializeTarget(IContext context, ActivityParameters activityParams) {
        String outputModelUriString = OptionsHandlerHelper.getInstance((IContext)context).getStringValue(context, "capella.core.transition", "outputModel", IOptionsConstants.OUTPUT_PROJECT_DEFAULT_VALUE);
        URI outputModelUri = URI.createPlatformResourceURI((String)outputModelUriString, (boolean)true);
        EditingDomain targetDomain = (EditingDomain)context.get((Object)"TRANSITION_SOURCE_EDITING_DOMAIN");
        context.put((Object)"TRANSITION_TARGET_EDITING_DOMAIN", (Object)targetDomain);
        ResourceSet resourceSet = targetDomain.getResourceSet();
        Resource outputResource = resourceSet.getResource(outputModelUri, true);
        context.put((Object)"_T_T_Res", (Object)outputResource);
        EObject outputProject = (EObject)outputResource.getContents().get(0);
        if (outputProject instanceof Project) {
            context.put((Object)"_TTRo", (Object)outputProject);
            Set<Resource> libraryResources = SubSystemContextHelper.getLibraryResources((Project)outputProject);
            if (libraryResources != null && !libraryResources.isEmpty()) {
                context.put((Object)"RESOURCES_FOR_LIBRARIES_OF_TARGET_PROJECT", libraryResources);
                context.put((Object)"ROOTS_FOR_LIBRARIES_OF_TARGET_PROJECT", SubSystemContextHelper.getLibraryRoots(libraryResources));
            } else {
                Object sourceProject = context.get((Object)"_TSRo");
                if (sourceProject instanceof Project) {
                    libraryResources = SubSystemContextHelper.getLibraryResources((Project)sourceProject);
                    context.put((Object)"RESOURCES_FOR_LIBRARIES_OF_TARGET_PROJECT", libraryResources);
                    context.put((Object)"ROOTS_FOR_LIBRARIES_OF_TARGET_PROJECT", SubSystemContextHelper.getLibraryRoots(libraryResources));
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultSessionHandler() {
        return new SubSystemSessionHandler();
    }

    protected IHandler createDefaultAttachmentHandler() {
        return new CapellaDefaultAttachmentHandler(){

            public boolean attachElementByReference(EObject sourceAttaching, EObject targetAttaching, EObject sourceAttached, EObject targetAttached, EReference sourceFeature, EReference targetFeature) {
                HoldingResourceHelper.ensureMoveElement((EObject)targetAttached, (EObject)targetAttaching);
                return super.attachElementByReference(sourceAttaching, targetAttaching, sourceAttached, targetAttached, sourceFeature, targetFeature);
            }
        };
    }

    protected IHandler createDefaultTraceabilityTargetHandler() {
        return new CompoundTraceabilityHandler((ITraceabilityConfiguration)new TransformationConfiguration());
    }
}

