/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases.handlers.traceability.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.transition.system2subsystem.multiphases.MultiphasesContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class RecTraceabilityHandler
implements ITraceabilityHandler {
    private final Map<MultiphasesContext.Mapping, SetMultimap<EObject, EObject>> mappingToTraceability = new HashMap<MultiphasesContext.Mapping, SetMultimap<EObject, EObject>>();

    public IStatus init(IContext context_p) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context_p) {
        return Status.OK_STATUS;
    }

    public void attachTraceability(EObject sourceElement_p, EObject targetElement_p, IContext context_p) {
        throw new UnsupportedOperationException("This handler is read only");
    }

    private SetMultimap<EObject, EObject> initTraceabilityMap(MultiphasesContext context_p) {
        HashMultimap map = HashMultimap.create();
        BlockArchitecture targetBlockArchitecture = context_p.getTempBlockArchitecture();
        PhysicalArchitecture sourcePA = context_p.getSourcePhysicalArchitecture();
        map.put((Object)sourcePA, (Object)targetBlockArchitecture);
        FunctionPkg sourceFunctionPkg = BlockArchitectureExt.getFunctionPkg((BlockArchitecture)sourcePA, (boolean)false);
        FunctionPkg targetFunctionPkg = BlockArchitectureExt.getFunctionPkg((BlockArchitecture)targetBlockArchitecture, (boolean)false);
        if (sourceFunctionPkg != null && targetFunctionPkg != null) {
            map.put((Object)sourceFunctionPkg, (Object)targetFunctionPkg);
        }
        AbstractFunction sourceFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)sourcePA, (boolean)false);
        AbstractFunction targetFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)targetBlockArchitecture, (boolean)false);
        if (sourceFunction != null && targetFunction != null) {
            map.put((Object)sourceFunction, (Object)targetFunction);
        }
        ComponentPkg sourceActorPkg = BlockArchitectureExt.getActorPkg((BlockArchitecture)sourcePA, (boolean)false);
        ComponentPkg targetActorPkg = BlockArchitectureExt.getActorPkg((BlockArchitecture)targetBlockArchitecture, (boolean)false);
        if (sourceActorPkg != null && targetActorPkg != null) {
            map.put((Object)sourceActorPkg, (Object)targetActorPkg);
        }
        ComponentPkg sourceContext = BlockArchitectureExt.getContext((BlockArchitecture)sourcePA, (boolean)false);
        ComponentPkg targetContext = BlockArchitectureExt.getContext((BlockArchitecture)targetBlockArchitecture, (boolean)false);
        if (sourceContext != null && targetContext != null) {
            map.put((Object)sourceContext, (Object)targetContext);
        }
        InterfacePkg sourceInterfacePkg = BlockArchitectureExt.getInterfacePkg((BlockArchitecture)sourcePA, (boolean)false);
        InterfacePkg targetInterfacePkg = BlockArchitectureExt.getInterfacePkg((BlockArchitecture)targetBlockArchitecture, (boolean)false);
        if (sourceInterfacePkg != null && targetInterfacePkg != null) {
            map.put((Object)sourceInterfacePkg, (Object)targetInterfacePkg);
        }
        Structure sourceRequirementsPkg = BlockArchitectureExt.getRequirementsPkg((BlockArchitecture)sourcePA, (boolean)false);
        Structure targetRequirementsPkg = BlockArchitectureExt.getRequirementsPkg((BlockArchitecture)targetBlockArchitecture, (boolean)false);
        if (sourceRequirementsPkg != null && targetRequirementsPkg != null) {
            map.put((Object)sourceRequirementsPkg, (Object)targetRequirementsPkg);
        }
        AbstractCapabilityPkg sourceCapabilityPkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)sourcePA, (boolean)false);
        AbstractCapabilityPkg targetCapabilityPkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)targetBlockArchitecture, (boolean)false);
        if (sourceCapabilityPkg != null && targetCapabilityPkg != null) {
            map.put((Object)sourceCapabilityPkg, (Object)targetCapabilityPkg);
        }
        map.put((Object)context_p.getSourcePhysicalArchitecture().getOwnedDataPkg(), (Object)context_p.getTempSystemAnalysis().getOwnedDataPkg());
        map.put((Object)context_p.getSourceSystemAnalysis().getOwnedDataPkg(), (Object)context_p.getTempSystemAnalysis().getOwnedDataPkg());
        map.put((Object)context_p.getSourceLogicalArchitecture().getOwnedDataPkg(), (Object)context_p.getTempSystemAnalysis().getOwnedDataPkg());
        this.initializeDataTypes((EObject)context_p.getSourceSystemAnalysis().getOwnedDataPkg(), (EObject)context_p.getTempSystemAnalysis().getOwnedDataPkg(), (SetMultimap<EObject, EObject>)map);
        this.initializeDataTypes((EObject)context_p.getSourceLogicalArchitecture().getOwnedDataPkg(), (EObject)context_p.getTempSystemAnalysis().getOwnedDataPkg(), (SetMultimap<EObject, EObject>)map);
        this.initializeDataTypes((EObject)context_p.getSourcePhysicalArchitecture().getOwnedDataPkg(), (EObject)context_p.getTempSystemAnalysis().getOwnedDataPkg(), (SetMultimap<EObject, EObject>)map);
        OperationalAnalysis oa = SystemEngineeringExt.getOperationalAnalysis((SystemEngineering)context_p.getSourceSystemEngineering());
        if (oa != null) {
            map.put((Object)oa.getOwnedDataPkg(), (Object)context_p.getTempSystemAnalysis().getOwnedDataPkg());
            this.initializeDataTypes((EObject)oa.getOwnedDataPkg(), (EObject)context_p.getTempSystemAnalysis().getOwnedDataPkg(), (SetMultimap<EObject, EObject>)map);
        }
        return map;
    }

    protected void initializeDataTypes(EObject source_p, EObject target_p, SetMultimap<EObject, EObject> map_p) {
        if (source_p.eClass() == target_p.eClass()) {
            map_p.put((Object)source_p, (Object)target_p);
            for (EReference reference : source_p.eClass().getEAllContainments()) {
                Object targetValue;
                Object sourceValue;
                if (!reference.isMany()) {
                    sourceValue = (EObject)source_p.eGet((EStructuralFeature)reference);
                    targetValue = (EObject)target_p.eGet((EStructuralFeature)reference);
                    if (sourceValue == null || targetValue == null || sourceValue.eClass() != targetValue.eClass()) continue;
                    this.initializeDataTypes((EObject)sourceValue, (EObject)targetValue, map_p);
                    continue;
                }
                sourceValue = source_p.eGet((EStructuralFeature)reference);
                targetValue = target_p.eGet((EStructuralFeature)reference);
                if (!(sourceValue instanceof EList) || !(targetValue instanceof EList)) continue;
                EList sourceList = (EList)sourceValue;
                EList targetList = (EList)targetValue;
                int i = 0;
                while (i < sourceList.size()) {
                    sourceValue = sourceList.get(i);
                    if (sourceValue != null && sourceValue instanceof EObject) {
                        EObject sourceObject = (EObject)sourceValue;
                        int j = 0;
                        while (j < targetList.size()) {
                            EObject targetObject = (EObject)targetList.get(j);
                            if (targetObject instanceof AbstractNamedElement && sourceObject instanceof AbstractNamedElement) {
                                AbstractNamedElement sourceNamed = (AbstractNamedElement)sourceObject;
                                AbstractNamedElement targetNamed = (AbstractNamedElement)targetObject;
                                if (sourceNamed.getName() == null && targetNamed.getName() == null || sourceNamed.getName() != null && sourceNamed.getName().equals(targetNamed.getName())) {
                                    this.initializeDataTypes(sourceObject, targetObject, map_p);
                                    break;
                                }
                            } else {
                                this.initializeDataTypes(sourceObject, targetObject, map_p);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public Set<EObject> retrieveTracedElements(EObject source_p, IContext context_p) {
        MultiphasesContext mcontext = (MultiphasesContext)context_p;
        MultiphasesContext.Mapping currentMapping = mcontext.getMapping();
        if (this.mappingToTraceability.get((Object)currentMapping) == null) {
            this.mappingToTraceability.put(currentMapping, this.initTraceabilityMap(mcontext));
        }
        SetMultimap<EObject, EObject> traceability = this.mappingToTraceability.get((Object)currentMapping);
        return traceability.get((Object)source_p);
    }

    public Collection<EObject> retrieveTracedElements(EObject source_p, IContext context_p, EClass clazz) {
        return Collections2.filter((Collection)this.retrieveTracedElements(source_p, context_p), (Predicate)Predicates.instanceOf((Class)clazz.getInstanceClass()));
    }

    public final boolean isTraced(EObject element_p, IContext context_p) {
        return this.retrieveTracedElements(element_p, context_p).size() > 0;
    }

    public Collection<EObject> retrieveSourceElements(EObject source_p, IContext context_p) {
        throw new UnsupportedOperationException();
    }

    public String getId(EObject element_p, IContext context_p) {
        throw new UnsupportedOperationException();
    }
}

