/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases.rules;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.selection.EClassSelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.ISelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.SelectionContextHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.transition.system2subsystem.crossphases.rules.pa.PhysicalComponentRule;
import org.polarsys.capella.transition.system2subsystem.multiphases.MultiphasesContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class PhysicalComponentRules {

    public static class ToLA
    extends PhysicalComponentRule {
        protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
            if (element_p instanceof PhysicalComponent && result_p instanceof AbstractActor) {
                return null;
            }
            if (element_p instanceof PhysicalComponent && ((PhysicalComponent)element_p).getDeployingPhysicalComponents().isEmpty()) {
                EObject sourceContainer = element_p.eContainer();
                EClassSelectionContext sContext = new EClassSelectionContext(SelectionContextHandlerHelper.getHandler((IContext)context_p).getSelectionContext(context_p, "SC__T", element_p, result_p), LaPackage.Literals.LOGICAL_COMPONENT);
                return TransformationHandlerHelper.getInstance((IContext)context_p).getBestTracedElement(sourceContainer, context_p, (ISelectionContext)sContext);
            }
            SystemEngineering eng = (SystemEngineering)context_p.get((Object)"_Tr_T_R");
            LogicalArchitecture la = (LogicalArchitecture)eng.getContainedLogicalArchitectures().get(0);
            return BlockArchitectureExt.getFirstComponent((ModellingArchitecture)la);
        }

        protected EObject transformDirectElement(EObject element_p, IContext context_p) {
            PhysicalComponent element = (PhysicalComponent)element_p;
            MultiphasesContext context = (MultiphasesContext)context_p;
            if (element.getNature() == PhysicalComponentNature.NODE) {
                PhysicalComponent tmp = element;
                while (tmp instanceof PhysicalComponent) {
                    if (context.getSelectedPhysicalComponents().contains(tmp)) {
                        return context.getTempRootComponent();
                    }
                    tmp = tmp.eContainer();
                }
            }
            EObject result = EcoreUtil.create((EClass)this.getTargetType(element_p, context_p));
            if (element_p instanceof AbstractNamedElement && result instanceof AbstractNamedElement) {
                ((AbstractNamedElement)result).setName(((AbstractNamedElement)element_p).getName());
            }
            return result;
        }

        public EClass getTargetType(EObject element_p, IContext context_p) {
            if (ContextScopeHandlerHelper.getInstance((IContext)context_p).contains("SOURCE_SCOPE", element_p, context_p)) {
                return LaPackage.Literals.LOGICAL_COMPONENT;
            }
            return LaPackage.Literals.LOGICAL_ACTOR;
        }

        public IStatus transformRequired(EObject source_p, IContext context_p) {
            if (ContextScopeHandlerHelper.getInstance((IContext)context_p).contains("SOURCE_SCOPE", source_p, context_p)) {
                return Status.OK_STATUS;
            }
            IStatus result = super.transformRequired(source_p, context_p);
            return result;
        }
    }

    public static class ToPA
    extends PhysicalComponentRule {
        protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
            if (element_p instanceof PhysicalComponent && result_p instanceof AbstractActor) {
                return null;
            }
            EObject bestContainer = null;
            EObject container = this.getSourceContainer(element_p, result_p, context_p);
            if (container != null) {
                EClassSelectionContext sContext = new EClassSelectionContext(SelectionContextHandlerHelper.getHandler((IContext)context_p).getSelectionContext(context_p, "SC__T", element_p, result_p), PaPackage.Literals.PHYSICAL_COMPONENT);
                bestContainer = TransformationHandlerHelper.getInstance((IContext)context_p).getBestTracedElement(container, context_p, (ISelectionContext)sContext);
            }
            return bestContainer;
        }

        public EClass getTargetType(EObject element_p, IContext context_p) {
            if (ContextScopeHandlerHelper.getInstance((IContext)context_p).contains("SOURCE_SCOPE", element_p, context_p)) {
                return PaPackage.Literals.PHYSICAL_COMPONENT;
            }
            return PaPackage.Literals.PHYSICAL_ACTOR;
        }

        public IStatus transformRequired(EObject source_p, IContext context_p) {
            IStatus result = super.transformRequired(source_p, context_p);
            if (source_p instanceof PhysicalComponent && ((PhysicalComponent)source_p).getNature() == PhysicalComponentNature.BEHAVIOR) {
                return new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Component ''{0}'' behavior ''{1}'' is not transitioned in the Physical Layer", (Object)LogHelper.getInstance().getText((Object)source_p)));
            }
            if (ContextScopeHandlerHelper.getInstance((IContext)context_p).contains("SOURCE_SCOPE", source_p, context_p)) {
                return Status.OK_STATUS;
            }
            return result;
        }
    }

    public static class ToSA
    extends PhysicalComponentRule {
    }
}

