/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases;

import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.transition.common.context.TransitionContext;

public class MultiphasesContext
extends TransitionContext {
    private Mapping mapping;

    public MultiphasesContext(Collection<?> selection_p) {
        this.put("TRANSPOSER_SELECTION", selection_p);
        this.put("SAVE_REQUIRED", Boolean.TRUE);
    }

    public Collection<? extends PhysicalComponent> getSelectedPhysicalComponents() {
        return (Collection)this.get("TRANSITION_SOURCES");
    }

    public void reset() {
    }

    public void setMapping(Mapping mapping_p) {
        this.mapping = mapping_p;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public BlockArchitecture getTempBlockArchitecture() {
        return this.mapping.getTempBlockArchitecture(this);
    }

    public SystemEngineering getTempSystemEngineering() {
        return (SystemEngineering)this.get("_Tr_T_R");
    }

    public SystemAnalysis getSourceSystemAnalysis() {
        return (SystemAnalysis)this.getSourceSystemEngineering().getContainedSystemAnalysis().get(0);
    }

    public LogicalArchitecture getSourceLogicalArchitecture() {
        return (LogicalArchitecture)this.getSourceSystemEngineering().getContainedLogicalArchitectures().get(0);
    }

    public PhysicalArchitecture getSourcePhysicalArchitecture() {
        return (PhysicalArchitecture)this.getSourceSystemEngineering().getContainedPhysicalArchitectures().get(0);
    }

    public SystemEngineering getSourceSystemEngineering() {
        return (SystemEngineering)this.get("_Tr_S_R");
    }

    public SystemAnalysis getTempSystemAnalysis() {
        return (SystemAnalysis)this.getTempSystemEngineering().getContainedSystemAnalysis().get(0);
    }

    public LogicalArchitecture getTempLogicalArchitecture() {
        return (LogicalArchitecture)this.getTempSystemEngineering().getContainedLogicalArchitectures().get(0);
    }

    public PhysicalArchitecture getTempPhysicalArchitecture() {
        return (PhysicalArchitecture)this.getTempSystemEngineering().getContainedPhysicalArchitectures().get(0);
    }

    public EObject getTempRootComponent() {
        return this.mapping.getTempRootComponent(this);
    }

    public static enum Mapping {
        SA("org.polarsys.capella.transition.system2subsystem.multiphases.sa", CtxPackage.Literals.SYSTEM_ANALYSIS),
        LA("org.polarsys.capella.transition.system2subsystem.multiphases.la", LaPackage.Literals.LOGICAL_ARCHITECTURE),
        PA("org.polarsys.capella.transition.system2subsystem.multiphases.pa", PaPackage.Literals.PHYSICAL_ARCHITECTURE);

        private final String mapping_id;
        private final EClass blockArchitecture;

        private Mapping(String mapping_id_p, EClass blockArchitecture_p) {
            this.mapping_id = mapping_id_p;
            this.blockArchitecture = blockArchitecture_p;
        }

        public String getMappingId() {
            return this.mapping_id;
        }

        public EClass getBlockArchitectureClass() {
            return this.blockArchitecture;
        }

        private BlockArchitecture getTempBlockArchitecture(MultiphasesContext context_p) {
            SystemEngineering eng = context_p.getTempSystemEngineering();
            for (ModellingArchitecture ma : eng.getOwnedArchitectures()) {
                if (!this.blockArchitecture.isInstance((Object)ma)) continue;
                return (BlockArchitecture)ma;
            }
            throw new IllegalStateException("No blockarchitecture of type '" + this.blockArchitecture.eClass().getName() + "' in temp system engineering! ");
        }

        private EObject getTempRootComponent(MultiphasesContext context_p) {
            BlockArchitecture ba = this.getTempBlockArchitecture(context_p);
            if (ba instanceof SystemAnalysis) {
                return ((SystemAnalysis)ba).getOwnedSystem();
            }
            if (ba instanceof LogicalArchitecture) {
                return ((LogicalArchitecture)ba).getOwnedLogicalComponent();
            }
            if (ba instanceof PhysicalArchitecture) {
                return ((PhysicalArchitecture)ba).getOwnedPhysicalComponent();
            }
            throw new IllegalStateException("No root component for " + this.blockArchitecture.eClass().getName());
        }
    }
}

