/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaIncomingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaOutgoingRelation;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.vp.requirements.Requirements.AbstractRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.InternalRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;

public class REQ_Relation_02
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        Map<UniqueRelation, Integer> uniqueRelationCountMap = this.getUniqueRelationCountMap(target);
        for (Map.Entry<UniqueRelation, Integer> entry : uniqueRelationCountMap.entrySet()) {
            if (entry.getValue() <= 1) continue;
            String relationTuple = "between SOURCE (" + EObjectLabelProviderHelper.getText((EObject)entry.getKey().getSourceElement()) + ") and TARGET (" + EObjectLabelProviderHelper.getText((EObject)entry.getKey().getTargetElement()) + ") of the same RELATION TYPE (" + EObjectLabelProviderHelper.getText((EObject)entry.getKey().getRelationType()) + ")";
            IStatus failureStatus = ctx.createFailureStatus(new Object[]{String.valueOf(EObjectLabelProviderHelper.getText((EObject)target)) + " " + EObjectLabelProviderHelper.getMetaclassLabel((EObject)target, (boolean)true) + " contains " + entry.getValue() + " duplicated relations " + relationTuple});
            statuses.add(failureStatus);
        }
        if (!statuses.isEmpty()) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        }
        return ctx.createSuccessStatus();
    }

    protected Map<UniqueRelation, Integer> getUniqueRelationCountMap(EObject target) {
        HashMap<UniqueRelation, Integer> relationCountMap;
        block4: {
            block3: {
                relationCountMap = new HashMap<UniqueRelation, Integer>();
                if (!(target instanceof Requirement)) break block3;
                Requirement req = (Requirement)target;
                for (AbstractRelation relation : req.getOwnedRelations()) {
                    UniqueRelation uniqueRelation;
                    if (relation instanceof InternalRelation) {
                        uniqueRelation = new UniqueRelation((EObject)((InternalRelation)relation).getSource(), (EObject)((InternalRelation)relation).getTarget(), (EObject)relation.getRelationType());
                        if (!this.isUniqueRelationValid(uniqueRelation)) continue;
                        this.updateRelationCountMap(relationCountMap, uniqueRelation);
                        continue;
                    }
                    if (!(relation instanceof CapellaIncomingRelation) || !this.isUniqueRelationValid(uniqueRelation = new UniqueRelation((EObject)((CapellaIncomingRelation)relation).getSource(), (EObject)((CapellaIncomingRelation)relation).getTarget(), (EObject)relation.getRelationType()))) continue;
                    this.updateRelationCountMap(relationCountMap, uniqueRelation);
                }
                break block4;
            }
            if (!(target instanceof CapellaElement)) break block4;
            CapellaElement capellaElement = (CapellaElement)target;
            for (ElementExtension ext : capellaElement.getOwnedExtensions()) {
                UniqueRelation uniqueRelation;
                if (!(ext instanceof CapellaOutgoingRelation) || !this.isUniqueRelationValid(uniqueRelation = new UniqueRelation((EObject)((CapellaOutgoingRelation)ext).getSource(), (EObject)((CapellaOutgoingRelation)ext).getTarget(), (EObject)((CapellaOutgoingRelation)ext).getRelationType()))) continue;
                this.updateRelationCountMap(relationCountMap, uniqueRelation);
            }
        }
        return relationCountMap;
    }

    protected void updateRelationCountMap(Map<UniqueRelation, Integer> relationCountMap, UniqueRelation uniqueRelation) {
        if (relationCountMap.containsKey(uniqueRelation)) {
            relationCountMap.put(uniqueRelation, relationCountMap.get(uniqueRelation) + 1);
        } else {
            relationCountMap.put(uniqueRelation, 1);
        }
    }

    protected boolean isUniqueRelationValid(UniqueRelation uniqueRelation) {
        return uniqueRelation.getSourceElement() != null && uniqueRelation.getTargetElement() != null && uniqueRelation.getRelationType() != null;
    }

    class UniqueRelation {
        EObject source;
        EObject target;
        EObject relationType;

        public UniqueRelation(EObject source, EObject target, EObject relationType) {
            this.source = source;
            this.target = target;
            this.relationType = relationType;
        }

        public EObject getSourceElement() {
            return this.source;
        }

        public EObject getTargetElement() {
            return this.target;
        }

        public EObject getRelationType() {
            return this.relationType;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            UniqueRelation relationToCompare = (UniqueRelation)obj;
            return this.source.equals(relationToCompare.getSourceElement()) && this.target.equals(relationToCompare.getTargetElement()) && this.relationType.equals(relationToCompare.getRelationType());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            result = 31 * result + (this.relationType == null ? 0 : this.relationType.hashCode());
            return result;
        }
    }
}

