/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.vp.requirements.model.helpers.TraceHelper;

public class TraceHelperTestCase
extends BasicTestCase {
    private static final String LEGACY_VALID = "./A/In-Flight Entertainment System.melodymodeller.bridgetraces";
    private static final String LEGACY_INVALID = "./A/In-Flight Entertainment System.yolo.bridgetraces";
    private static final String MODERN_VALID = "./A/In-Flight Entertainment System.capella.bridgetraces";
    private static final String MODERN_INVALID = "./A/In-Flight Entertainment System.capellaInvalid.bridgetraces";

    public void test() throws Exception {
        this.testResourceHelpers();
    }

    public void testResourceHelpers() {
        IFile legacyValidFile = FileHelper.getPlatformFile((String)LEGACY_VALID);
        IFile legacyInvalidFile = FileHelper.getPlatformFile((String)LEGACY_INVALID);
        IFile modernValidFile = FileHelper.getPlatformFile((String)MODERN_VALID);
        IFile modernInvalidFile = FileHelper.getPlatformFile((String)MODERN_INVALID);
        TraceHelperTestCase.assertTrue((boolean)TraceHelper.isLegacyTraceResource((IResource)legacyValidFile));
        TraceHelperTestCase.assertFalse((boolean)TraceHelper.isLegacyTraceResource((IResource)modernValidFile));
        TraceHelperTestCase.assertFalse((boolean)TraceHelper.isLegacyTraceResource((IResource)legacyInvalidFile));
        TraceHelperTestCase.assertTrue((boolean)TraceHelper.isTraceResource((IResource)modernValidFile));
        TraceHelperTestCase.assertFalse((boolean)TraceHelper.isTraceResource((IResource)legacyValidFile));
        TraceHelperTestCase.assertFalse((boolean)TraceHelper.isTraceResource((IResource)modernInvalidFile));
        TraceHelperTestCase.assertEquals((Object)Path.fromOSString((String)MODERN_VALID), (Object)TraceHelper.convertLegacyTracePathToModern((IPath)Path.fromOSString((String)LEGACY_VALID)));
    }
}

