/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.vp.requirements.ju.RequirementsDiagram;

public class RequirementsToolsTestCase
extends AbstractDiagramTestCase {
    private static final String REQ_1 = "fe5ca911-1f2f-40eb-932b-3e4dab3eed86";
    private static final String REQ_2 = "269f08ec-513d-41fd-96ec-1ee6c2dbd8cd";
    private static final String REQ_3 = "bd488918-1fa9-4278-a9c9-18874d4ddeb2";
    private static final String REQ_4 = "4eff0b4f-cbf5-434b-b021-69b882b6e2f5";
    private static final String REQ_5 = "aae247d0-5cc1-4dba-8a26-a9370c976366";

    protected String getRequiredTestModel() {
        return "In-Flight Entertainment System With Requirements";
    }

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext sessionContext = new SessionContext(session);
        HashSet<String> alreadyTested = new HashSet<String>();
        for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(session)) {
            DDiagram diagram;
            String diagramType;
            if (!(representation instanceof DDiagram) || alreadyTested.contains(diagramType = (diagram = (DDiagram)representation).getDescription().getName())) continue;
            alreadyTested.add(diagramType);
            this.testRequirementsToolsOnDiagram(diagram, sessionContext);
        }
    }

    private String getFirstCapellaElement(RequirementsDiagram diagram) {
        for (DNode node : diagram.getDiagram().getNodes()) {
            EObject nodeTarget = node.getTarget();
            if (!(nodeTarget instanceof CapellaElement)) continue;
            CapellaElement target = (CapellaElement)nodeTarget;
            return target.getId();
        }
        for (DDiagramElementContainer container : diagram.getDiagram().getContainers()) {
            EObject containerTarget = container.getTarget();
            if (!(containerTarget instanceof CapellaElement)) continue;
            CapellaElement target = (CapellaElement)containerTarget;
            return target.getId();
        }
        return null;
    }

    private void testRequirementsToolsOnDiagram(DDiagram rep, SessionContext sessionContext) {
        System.out.println("Test requirements tools on diagram: " + rep.getName());
        RequirementsDiagram diagram = new RequirementsDiagram(sessionContext, rep);
        diagram.showRequirements(REQ_3);
        this.testRequirementsToolsOnGivenElement(diagram, REQ_3, REQ_1, REQ_2);
        diagram.hideRequirements(REQ_3);
        String aCapellaElement = this.getFirstCapellaElement(diagram);
        if (aCapellaElement != null) {
            this.testRequirementsToolsOnGivenElement(diagram, aCapellaElement, REQ_4, REQ_5);
        }
    }

    private void testRequirementsToolsOnGivenElement(RequirementsDiagram diagram, String id, String incomingReq, String outgoingReq) {
        diagram.showRequirements(incomingReq, outgoingReq);
        diagram.hasView(outgoingReq);
        diagram.hasView(incomingReq);
        diagram.createRequirementLink(id, outgoingReq);
        diagram.createRequirementLink(incomingReq, id);
        diagram.hideOutgoingRequirements(outgoingReq, id);
        diagram.hasntView(outgoingReq);
        diagram.hideIncomingRequirements(incomingReq, id);
        diagram.hasntView(incomingReq);
        diagram.showOutgoingRequirements(outgoingReq, id);
        diagram.hasView(outgoingReq);
        diagram.showIncomingRequirements(incomingReq, id);
        diagram.hasView(incomingReq);
        diagram.hideRequirements(outgoingReq, incomingReq);
        diagram.hasntView(outgoingReq);
        diagram.hasntView(incomingReq);
        diagram.showAllLinkedRequirements(id);
        diagram.hasView(outgoingReq);
        diagram.hasView(incomingReq);
    }
}

