/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridge;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolFunction;
import org.eclipse.emf.diffmerge.bridge.incremental.BridgeTraceBasedMatchPolicy;
import org.eclipse.emf.diffmerge.bridge.interactive.EMFInteractiveBridge;
import org.eclipse.emf.diffmerge.bridge.interactive.UpdateDialog;
import org.eclipse.emf.diffmerge.bridge.traces.gen.bridgetraces.BridgetracesFactory;
import org.eclipse.emf.diffmerge.bridge.traces.gen.bridgetraces.Trace;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergeSelector;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategorySet;
import org.eclipse.emf.diffmerge.ui.viewers.categories.DifferenceCategorySet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaModule;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaTypesFolder;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.Messages;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.RequirementEMFSYmbolFunction;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.RequirementsComparisonViewer;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.RequirementsVPMergeDialog;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.categories.EClassCategory;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.categories.RelationIdentifierCategory;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.categories.ReqIFTextCategory;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.vp.requirements.Requirements.ReqIFElement;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsPackage;

public class RequirementsVPBridge
extends EMFInteractiveBridge<IEditableModelScope, IEditableModelScope> {
    public static IEditableModelScope temporaryScope = null;
    IEditableModelScope _sourceScope;
    IEditableModelScope _targetScope;

    public RequirementsVPBridge(IEditableModelScope sourceScope, IEditableModelScope targetScope, IBridge<IEditableModelScope, IEditableModelScope> bridge, IDiffPolicy<EObject> diffPolicy, IMergePolicy<EObject> mergePolicy, IMergeSelector<EObject> merger) {
        super(bridge, diffPolicy, mergePolicy, merger);
        this._sourceScope = sourceScope;
        this._targetScope = targetScope;
    }

    protected IBridgeTrace.Editable createTrace() {
        Trace trace = BridgetracesFactory.eINSTANCE.createTrace();
        this.initializeTrace(trace);
        return trace;
    }

    protected EComparison compare(IEditableModelScope created, IEditableModelScope existing, IBridgeTrace createdTrace, IBridgeTrace existingTrace, IProgressMonitor monitor) {
        EComparisonImpl result = new EComparisonImpl((IEditableTreeDataScope)existing, (IEditableTreeDataScope)created);
        BridgeTraceBasedMatchPolicy<EObject> matchPolicy = new BridgeTraceBasedMatchPolicy<EObject>((ITreeDataScope)created, createdTrace, existingTrace){

            public Object getMatchID(EObject element, ITreeDataScope<EObject> scope) {
                Object trace = super.getMatchID((Object)element, scope);
                if (trace == null) {
                    trace = EcoreUtil.getID((EObject)element);
                }
                return trace;
            }
        };
        result.compute((IMatchPolicy)matchPolicy, this.getDiffPolicy(), this.getMergePolicy(), monitor);
        return result;
    }

    public IEditableModelScope createIntermediateDataSet(IEditableModelScope sourceDataSet, IEditableModelScope targetDataSet) {
        IEditableModelScope scope = super.createIntermediateDataSet((Object)sourceDataSet, targetDataSet);
        this.initializeTemporaryScope(scope);
        temporaryScope = scope;
        return temporaryScope;
    }

    protected void initializeTemporaryScope(final IEditableModelScope scope) {
        IEditableModelScope targetScope = this._targetScope;
        Resource target = EcoreUtil.getRootContainer((EObject)((EObject)targetScope.getContents().get(0))).eResource();
        Resource targetLoadedInSourceScope = ((EObject)this._sourceScope.getContents().get(0)).eResource().getResourceSet().getResource(target.getURI(), true);
        scope.add((Object)((EObject)targetLoadedInSourceScope.getContents().get(0)));
        ExecutionManager manager = TransactionHelper.getExecutionManager((Collection)this._sourceScope.getContents());
        if (manager != null) {
            manager.execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    Resource holdingResource = HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)TransactionHelper.getEditingDomain((Collection)RequirementsVPBridge.this._sourceScope.getContents()));
                    Project project = ProjectExt.getProject((EObject)((EObject)scope.getContents().get(0)));
                    HoldingResourceHelper.attachToHoldingResource((EObject)project, (Resource)holdingResource);
                    RequirementsVPBridge.this.removeImportedModules(project);
                    TreeIterator it = project.eAllContents();
                    HashMap capellaRelationsMap = new HashMap();
                    while (it.hasNext()) {
                        EObject element = (EObject)it.next();
                        if (element instanceof CapellaRelation) {
                            RequirementsVPBridge.this.updateCapellaRelationsMap((CapellaRelation)element, capellaRelationsMap);
                            continue;
                        }
                        if (!(element instanceof ModelElement)) continue;
                        ((ModelElement)element).getId();
                    }
                    RequirementsVPBridge.this.removeCapellaRelations(capellaRelationsMap);
                }
            });
        }
    }

    void removeImportedModules(Project project) {
        for (EObject block : EObjectExt.getAll((EObject)project, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE)) {
            ArrayList<ElementExtension> toBeRemoved = new ArrayList<ElementExtension>();
            for (ElementExtension ext : ((BlockArchitecture)block).getOwnedExtensions()) {
                String reqifid;
                if (!(ext instanceof ReqIFElement) || (reqifid = ((ReqIFElement)ext).getReqIFIdentifier()) == null || reqifid.isEmpty()) continue;
                if (ext instanceof CapellaModule) {
                    toBeRemoved.add(ext);
                    continue;
                }
                if (!(ext instanceof CapellaTypesFolder)) continue;
                ((CapellaTypesFolder)ext).getOwnedTypes().clear();
                ((CapellaTypesFolder)ext).getOwnedDefinitionTypes().clear();
            }
            ((BlockArchitecture)block).getOwnedExtensions().removeAll(toBeRemoved);
        }
    }

    private void updateCapellaRelationsMap(CapellaRelation capellaRelation, Map<CapellaRelation, Collection<?>> capellaRelationsMap) {
        Object containingObject;
        EStructuralFeature containingFeature;
        EObject container = capellaRelation.eContainer();
        if (container != null && (containingFeature = capellaRelation.eContainingFeature()) != null && (containingObject = container.eGet(containingFeature)) instanceof Collection) {
            Collection containingCollection = (Collection)containingObject;
            capellaRelationsMap.put(capellaRelation, containingCollection);
        }
    }

    private void removeCapellaRelations(Map<CapellaRelation, Collection<?>> capellaRelationsMap) {
        for (Map.Entry<CapellaRelation, Collection<?>> entry : capellaRelationsMap.entrySet()) {
            CapellaRelation capellaRelation = entry.getKey();
            Collection<?> containingCollection = entry.getValue();
            try {
                containingCollection.remove(capellaRelation);
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
        }
    }

    protected void handleMergedDifferences(final IComparison<EObject> comparison, final IBridgeTrace createdTrace, final IBridgeTrace existingTrace) {
        ExecutionManager manager = TransactionHelper.getExecutionManager((Collection)this._targetScope.getContents());
        if (manager != null) {
            manager.execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    RequirementsVPBridge.super.handleMergedDifferences(comparison, createdTrace, existingTrace);
                }
            });
        }
    }

    protected EMFDiffNode createDiffNode(EComparison comparison, EditingDomain domain) {
        EMFDiffNode diffNode = super.createDiffNode(comparison, domain);
        Collection remainingDifferences = comparison.getRemainingDifferences();
        DifferenceCategorySet set = new DifferenceCategorySet(Messages.Categories_Name, Messages.Categories_Description);
        set.getChildren().add((Object)new EClassCategory(RequirementsPackage.Literals.INTERNAL_RELATION, Messages.Categories_InternalRelations, RequirementsPackage.Literals.INTERNAL_RELATION));
        EClassCategory typesFolderEClassCategory = new EClassCategory(RequirementsPackage.Literals.TYPES_FOLDER, Messages.Categories_Types, RequirementsPackage.Literals.ENUM_VALUE, RequirementsPackage.Literals.DATA_TYPE_DEFINITION, RequirementsPackage.Literals.ATTRIBUTE_DEFINITION, RequirementsPackage.Literals.ABSTRACT_TYPE, RequirementsPackage.Literals.TYPES_FOLDER);
        typesFolderEClassCategory.setActive(true);
        set.getChildren().add((Object)typesFolderEClassCategory);
        set.getChildren().add((Object)new RelationIdentifierCategory());
        set.getChildren().add((Object)new ReqIFTextCategory());
        diffNode.getCategoryManager().addCategories((IDifferenceCategorySet)set);
        return diffNode;
    }

    public void initializeTrace(Trace trace) {
        trace.setSymbolFunction((ISymbolFunction)RequirementEMFSYmbolFunction.getInstance());
    }

    protected AbstractComparisonViewer createComparisonViewer(Composite parent) {
        return new RequirementsComparisonViewer(parent);
    }

    protected UpdateDialog createMergeDialog(EMFDiffNode diffNode_p) {
        return new RequirementsVPMergeDialog(Display.getDefault().getActiveShell(), this.getTitle(), diffNode_p);
    }
}

