/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.bridge.impl.AbstractNamedElement;
import org.eclipse.emf.diffmerge.bridge.impl.emf.EMFSymbolFunction;
import org.eclipse.emf.diffmerge.bridge.mapping.Messages;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryIdentifier;
import org.eclipse.emf.diffmerge.bridge.util.AbstractLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.util.CollectionsUtil;
import org.eclipse.emf.diffmerge.bridge.util.structures.IPureStructure;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryLoggingMessage
extends AbstractLoggingMessage {
    public QueryLoggingMessage(IQueryExecution queryExecution_p) {
        super((Object)queryExecution_p);
    }

    protected String getAdditionalInfo() {
        return "";
    }

    protected String getMessageBody() {
        IQueryIdentifier<?> queryIdentifier = this.getQueryIdentifier();
        if (queryIdentifier == null) {
            return Messages.BridgeLogger_EmptyQueryExecutionError;
        }
        Object queryResult = this.getQueryResult();
        if (queryResult == null) {
            return Messages.BridgeLogger_EmptyQueryResultError;
        }
        StringBuilder builder = new StringBuilder("[");
        String queryName = this.getQueryName(queryIdentifier);
        builder.append(queryName);
        builder.append("] returns {");
        if (queryResult instanceof EObject) {
            this.serializeObject(queryResult, builder);
        } else if (queryResult instanceof IPureStructure) {
            Collection contents = ((IPureStructure)queryResult).asCollection();
            for (Object object : contents) {
                this.serializeObject(object, builder);
                builder.append(", ");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public Collection<?> getObjects() {
        Object qResult = this.getQueryResult();
        Collection<Object> result = qResult == null ? Collections.emptySet() : CollectionsUtil.flatten((Object)qResult);
        return result;
    }

    protected String getPrefix() {
        StringBuilder builder = new StringBuilder();
        int depth = ((IQueryExecution)this.getQueryObject()).getAll().size();
        builder.append("\t|");
        int i = 1;
        while (i < depth) {
            builder.append("\t|");
            ++i;
        }
        builder.append("__Query ");
        return builder.toString();
    }

    public IQueryIdentifier<?> getQueryIdentifier() {
        List<IQueryIdentifier<?>> queryIdentifiers = ((IQueryExecution)this.getQueryObject()).getQueryIdentifiers();
        if (queryIdentifiers.size() == 0) {
            return null;
        }
        return queryIdentifiers.get(queryIdentifiers.size() - 1);
    }

    protected String getQueryName(IQueryIdentifier<?> queryIdentifier_p) {
        String queryName = null;
        queryName = queryIdentifier_p instanceof AbstractNamedElement ? ((AbstractNamedElement)queryIdentifier_p).getName() : queryIdentifier_p.toString();
        return queryName;
    }

    protected Object getQueryObject() {
        return this.getObjectToLabel().keySet().iterator().next();
    }

    public Object getQueryResult() {
        if (this.getQueryIdentifier() != null) {
            return ((IQueryExecution)this.getQueryObject()).get(this.getQueryIdentifier());
        }
        return null;
    }

    protected void serializeObject(Object object_p, StringBuilder builder_p) {
        EMFSymbolFunction function = EMFSymbolFunction.getInstance();
        String typeName = null;
        typeName = object_p instanceof EObject ? ((EObject)object_p).eClass().getName() : object_p.getClass().getSimpleName();
        builder_p.append("(");
        builder_p.append(typeName).append(" \"");
        builder_p.append(this.getObjectLabel(object_p)).append("\"");
        builder_p.append("[").append(function.getSymbol(object_p)).append("])");
    }
}

