/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.vp.requirements.model.helpers.RelationAnnotationHelper;
import org.polarsys.kitalpha.vp.requirements.Requirements.RelationType;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;

public class RequirementMigrationContribution
extends AbstractMigrationContribution {
    private static final String idseparator = ";";

    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        super.unaryMigrationExecute(currentElement, context);
        if (currentElement instanceof DRepresentationDescriptor) {
            DRepresentation representation = ((DRepresentationDescriptor)currentElement).getRepresentation();
            this.migrateAllocations((DRepresentationDescriptor)currentElement, "http://www.polarsys.org/capella/vp/requirements/IncomingRelation", representation);
            this.migrateAllocations((DRepresentationDescriptor)currentElement, "http://www.polarsys.org/capella/vp/requirements/OutgoingRelation", representation);
        }
    }

    public void migrateAllocations(DRepresentationDescriptor descriptor, String relationType, DRepresentation representation) {
        ArrayList<Couple> result = new ArrayList<Couple>();
        DAnnotation annotation = DAnnotationHelper.getAnnotation((String)relationType, (DModelElement)representation, (boolean)false);
        if (annotation != null) {
            Collection resources = RepresentationHelper.getSemanticResources((DRepresentationDescriptor)descriptor);
            for (Map.Entry detail : annotation.getDetails()) {
                String elementURIs = (String)detail.getValue();
                if (elementURIs == null || elementURIs.isEmpty()) continue;
                try {
                    URI typeURI;
                    String[] elementURI = elementURIs.split(idseparator);
                    String reqId = elementURI[0];
                    URI reqURI = URI.createURI((String)reqId);
                    if (reqURI != null && reqURI.hasFragment()) {
                        reqId = reqURI.fragment();
                    }
                    String typeId = null;
                    if (elementURI.length > 1) {
                        typeId = elementURI[1];
                    }
                    if (typeId != null && (typeURI = URI.createURI((String)typeId)) != null && typeURI.hasFragment()) {
                        typeId = typeURI.fragment();
                    }
                    if (reqId == null || reqId.isEmpty()) continue;
                    for (Resource resource : resources) {
                        if (resource == null) continue;
                        EObject reqObj = resource.getEObject(reqId);
                        EObject typeObj = null;
                        if (typeId != null && !typeId.isEmpty()) {
                            typeObj = resource.getEObject(typeId);
                        }
                        if (!(reqObj instanceof Requirement)) continue;
                        result.add(new Couple((Object)((Requirement)reqObj), (Object)(typeObj instanceof RelationType ? (RelationType)typeObj : null)));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            RelationAnnotationHelper.addAllocations((DRepresentationDescriptor)descriptor, (String)relationType, result);
            DAnnotationHelper.deleteAnnotation((String)relationType, (DModelElement)representation);
        }
    }
}

