/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.transition;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.test.transition.CyberTopDownTransitionTestCase;

public class CybersecurityPkgTransitionTest
extends CyberTopDownTransitionTestCase {
    Threat threat1;
    Threat threat2;
    Threat threat3;
    Threat threat4;
    PrimaryAsset primaryAsset1;
    PrimaryAsset primaryAsset2;
    PrimaryAsset primaryAsset3;
    PrimaryAsset primaryAsset4;
    CybersecurityPkg cybersecPkg1;
    CybersecurityPkg cybersecPkg2;
    PrimaryAssetMember primaryAssetMember;
    ExchangeItem exchangeItem;

    @Override
    protected void init() {
        super.init();
        this.threat1 = CybersecurityFactory.eINSTANCE.createThreat();
        this.threat2 = CybersecurityFactory.eINSTANCE.createThreat();
        this.threat3 = CybersecurityFactory.eINSTANCE.createThreat();
        this.threat4 = CybersecurityFactory.eINSTANCE.createThreat();
        this.primaryAsset1 = CybersecurityFactory.eINSTANCE.createFunctionalPrimaryAsset();
        this.primaryAsset2 = CybersecurityFactory.eINSTANCE.createInformationPrimaryAsset();
        this.primaryAsset3 = CybersecurityFactory.eINSTANCE.createFunctionalPrimaryAsset();
        this.primaryAsset4 = CybersecurityFactory.eINSTANCE.createInformationPrimaryAsset();
        this.primaryAssetMember = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
        this.exchangeItem = InformationFactory.eINSTANCE.createExchangeItem();
        this.primaryAssetMember.setMember((ModelElement)this.exchangeItem);
        this.primaryAsset2.getOwnedMembers().add((Object)this.primaryAssetMember);
        this.cybersecPkg1 = CybersecurityFactory.eINSTANCE.createCybersecurityPkg();
        this.cybersecPkg2 = CybersecurityFactory.eINSTANCE.createCybersecurityPkg();
        this.cybersecPkg1.getOwnedThreats().add((Object)this.threat3);
        this.cybersecPkg1.getOwnedPrimaryAssets().add((Object)this.primaryAsset3);
        this.cybersecPkg2.getOwnedThreats().add((Object)this.threat4);
        this.cybersecPkg2.getOwnedPrimaryAssets().add((Object)this.primaryAsset4);
        this.oaPkg.getOwnedThreats().add((Object)this.threat1);
        this.oaPkg.getOwnedThreats().add((Object)this.threat2);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.primaryAsset1);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.primaryAsset2);
        this.oaPkg.getOwnedCybersecurityPkgs().add((Object)this.cybersecPkg1);
        this.cybersecPkg1.getOwnedCybersecurityPkgs().add((Object)this.cybersecPkg2);
    }

    @Override
    public void doTest() {
        this.performThreatTransition(this.getObjects(new String[]{this.oaPkg.getId()}));
        this.checkTransitions(this.saPkg);
        this.performCybersecurityTransition(this.getObjects(new String[]{this.saPkg.getId()}));
        this.checkTransitions(this.laPkg);
        this.performThreatTransition(this.getObjects(new String[]{this.laPkg.getId()}));
        this.checkTransitions(this.paPkg);
    }

    protected void checkTransitions(CybersecurityPkg pkg) {
        this.threat1 = (Threat)this.mustBeTransitioned(this.threat1.getId(), (EObject)pkg);
        this.threat2 = (Threat)this.mustBeTransitioned(this.threat2.getId(), (EObject)pkg);
        this.primaryAsset1 = (PrimaryAsset)this.mustBeTransitioned(this.primaryAsset1.getId(), (EObject)pkg);
        this.primaryAsset2 = (PrimaryAsset)this.mustBeTransitioned(this.primaryAsset2.getId(), (EObject)pkg);
        this.cybersecPkg1 = (CybersecurityPkg)this.mustBeTransitioned(this.cybersecPkg1.getId(), (EObject)pkg);
        this.cybersecPkg2 = (CybersecurityPkg)this.mustBeTransitioned(this.cybersecPkg2.getId(), (EObject)this.cybersecPkg1);
        this.threat3 = (Threat)this.mustBeTransitioned(this.threat3.getId(), (EObject)this.cybersecPkg1);
        this.threat4 = (Threat)this.mustBeTransitioned(this.threat4.getId(), (EObject)this.cybersecPkg2);
        this.primaryAsset3 = (PrimaryAsset)this.mustBeTransitioned(this.primaryAsset3.getId(), (EObject)this.cybersecPkg1);
        this.primaryAsset4 = (PrimaryAsset)this.mustBeTransitioned(this.primaryAsset4.getId(), (EObject)this.cybersecPkg2);
        BlockArchitecture blockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)pkg);
        long noPkg = blockArchitecture.getOwnedExtensions().stream().filter(CybersecurityPkg.class::isInstance).count();
        CybersecurityPkgTransitionTest.assertTrue((noPkg == 1L ? 1 : 0) != 0);
    }
}

