/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.transition;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.transition.CyberTransitionCommandHelper;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;

public abstract class CyberTopDownTransitionTestCase
extends TopDownTransitionTestCase {
    BlockArchitecture oaArch;
    BlockArchitecture saArch;
    BlockArchitecture laArch;
    BlockArchitecture paArch;
    CybersecurityPkg oaPkg;
    CybersecurityPkg saPkg;
    CybersecurityPkg laPkg;
    CybersecurityPkg paPkg;
    Project project;
    CybersecurityServices services;
    Session session;

    protected void init() {
        this.session = this.getSession(this.getRequiredTestModels().get(0));
        this.project = SessionHelper.getCapellaProject((Session)this.session);
        this.services = new CybersecurityServices();
        this.oaArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.OA, (Project)this.project);
        this.saArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.SA, (Project)this.project);
        this.laArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.LA, (Project)this.project);
        this.paArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.PA, (Project)this.project);
        this.oaPkg = this.services.getDefaultCyberSecurityPackage((EObject)this.oaArch, true);
        this.saPkg = this.services.getDefaultCyberSecurityPackage((EObject)this.saArch, true);
        this.laPkg = this.services.getDefaultCyberSecurityPackage((EObject)this.laArch, true);
        this.paPkg = this.services.getDefaultCyberSecurityPackage((EObject)this.paArch, true);
    }

    protected abstract void doTest();

    public void performTest() throws Exception {
        this.init();
        this.doTest();
    }

    public void performThreatTransition(Collection<? extends EObject> elements) {
        this.performCybersecurityTransition(elements);
    }

    public void performPrimaryAssetTransition(Collection<? extends EObject> elements) {
        this.performCybersecurityTransition(elements);
    }

    public void performCybersecurityTransition(Collection<? extends EObject> elements) {
        this.executeCommand(CyberTransitionCommandHelper.getInstance().getCybersecurityTransitionCommand(elements, (IProgressMonitor)new NullProgressMonitor()));
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("CyberEmptyModel");
    }
}

