/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.model.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.helpers.interaction.delegates.AbstractCapabilityHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityRealization;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.Threat;

public class ThreatHelper {
    private static final ThreatHelper instance = new ThreatHelper();

    public static ThreatHelper getInstance() {
        return instance;
    }

    public Object doSwitch(Threat object, EStructuralFeature feature) {
        if (feature.equals(CybersecurityPackage.Literals.THREAT__REALIZED_THREATS)) {
            return this.getRealizedThreats(object);
        }
        if (feature.equals(CybersecurityPackage.Literals.THREAT__REALIZING_THREATS)) {
            return this.getRealizingThreats(object);
        }
        return AbstractCapabilityHelper.getInstance().doSwitch((AbstractCapability)object, feature);
    }

    protected List<Threat> getRealizedThreats(Threat element) {
        ArrayList<Threat> ret = new ArrayList<Threat>();
        for (AbstractTrace obj : element.getOutgoingTraces()) {
            AbstractCapabilityRealization link;
            if (!(obj instanceof AbstractCapabilityRealization) || !((link = (AbstractCapabilityRealization)obj).getRealizedCapability() instanceof Threat)) continue;
            ret.add((Threat)link.getRealizedCapability());
        }
        return ret;
    }

    protected List<Threat> getRealizingThreats(Threat element) {
        ArrayList<Threat> ret = new ArrayList<Threat>();
        for (AbstractTrace obj : element.getIncomingTraces()) {
            AbstractCapabilityRealization link;
            if (!(obj instanceof AbstractCapabilityRealization) || !((link = (AbstractCapabilityRealization)obj).getRealizingCapability() instanceof Threat)) continue;
            ret.add((Threat)link.getRealizingCapability());
        }
        return ret;
    }
}

