/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.transition;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.system.topdown.preferences.PreferenceHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.test.transition.CyberTopDownTransitionTestCase;

public abstract class PrimaryAssetTransitionTest
extends CyberTopDownTransitionTestCase {
    PrimaryAsset primaryAsset;
    PrimaryAsset primaryAsset2;
    SecurityNeeds securityNeeds;
    List<PrimaryAssetMember> primaryAssetMembers;
    ExchangeItem exchangeItem;

    protected abstract PrimaryAsset createPrimaryAsset();

    protected abstract void addPAMMembers();

    protected abstract void checkPAMMembersTransitioned(BlockArchitectureExt.Type var1);

    @Override
    protected void init() {
        super.init();
        this.primaryAsset = this.createPrimaryAsset();
        this.primaryAsset2 = this.createPrimaryAsset();
        this.exchangeItem = InformationFactory.eINSTANCE.createExchangeItem();
        this.securityNeeds = CybersecurityFactory.eINSTANCE.createSecurityNeeds();
        CybersecurityQueries.setConfidentialityFromIndex((SecurityNeeds)this.securityNeeds, (int)1, (EnumerationPropertyType)CybersecurityQueries.getConfidentialityPropertyType((Project)this.project));
        CybersecurityQueries.setIntegrityFromIndex((SecurityNeeds)this.securityNeeds, (int)1, (EnumerationPropertyType)CybersecurityQueries.getIntegrityPropertyType((Project)this.project));
        CybersecurityQueries.setTraceabilityFromIndex((SecurityNeeds)this.securityNeeds, (int)1, (EnumerationPropertyType)CybersecurityQueries.getTraceabilityPropertyType((Project)this.project));
        CybersecurityQueries.setAvailabilityFromIndex((SecurityNeeds)this.securityNeeds, (int)1, (EnumerationPropertyType)CybersecurityQueries.getAvailabilityPropertyType((Project)this.project));
        this.primaryAsset.getOwnedExtensions().add((Object)this.securityNeeds);
        this.primaryAssetMembers = new ArrayList<PrimaryAssetMember>();
        this.addPAMMembers();
        this.primaryAsset.getOwnedMembers().addAll(this.primaryAssetMembers);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.primaryAsset);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.primaryAsset2);
        BlockArchitectureExt.getInterfacePkg((BlockArchitecture)this.oaArch, (boolean)false).getOwnedExchangeItems().add((Object)this.exchangeItem);
    }

    @Override
    protected void doTest() {
        PreferenceHelper.getInstance().setBooleanValue("projection.exchangeItems", Boolean.valueOf(true));
        this.performPrimaryAssetTransition(this.getObjects(new String[]{this.primaryAsset.getId()}));
        PrimaryAsset systemPa = (PrimaryAsset)this.mustBeTransitioned(this.primaryAsset.getId(), (EObject)this.saPkg);
        SecurityNeeds transitionedSecurityNeeds = (SecurityNeeds)this.mustBeTransitionedDirecltyContainedBy(this.securityNeeds.getId(), (EObject)systemPa);
        this.checkSecurityNeedsProperlyTransitioned(transitionedSecurityNeeds);
        List systemPams = this.primaryAssetMembers.stream().map(pam -> (PrimaryAssetMember)this.mustBeTransitionedDirecltyContainedBy(pam.getId(), (EObject)systemPa)).collect(Collectors.toList());
        this.checkPAMMembersTransitioned(BlockArchitectureExt.Type.SA);
        PrimaryAssetTransitionTest.assertTrue((boolean)this.primaryAsset2.getIncomingTraces().isEmpty());
        this.performPrimaryAssetTransition(this.getObjects(new String[]{systemPa.getId()}));
        PrimaryAsset logicalPa = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(systemPa.getId(), (EObject)this.laPkg);
        transitionedSecurityNeeds = (SecurityNeeds)this.mustBeTransitionedDirecltyContainedBy(transitionedSecurityNeeds.getId(), (EObject)logicalPa);
        this.checkSecurityNeedsProperlyTransitioned(transitionedSecurityNeeds);
        List logicalPams = systemPams.stream().map(pam -> (PrimaryAssetMember)this.mustBeTransitionedDirecltyContainedBy(pam.getId(), (EObject)logicalPa)).collect(Collectors.toList());
        this.checkPAMMembersTransitioned(BlockArchitectureExt.Type.LA);
        this.performPrimaryAssetTransition(this.getObjects(new String[]{logicalPa.getId()}));
        PrimaryAsset physicalPa = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(logicalPa.getId(), (EObject)this.paPkg);
        transitionedSecurityNeeds = (SecurityNeeds)this.mustBeTransitionedDirecltyContainedBy(transitionedSecurityNeeds.getId(), (EObject)physicalPa);
        this.checkSecurityNeedsProperlyTransitioned(transitionedSecurityNeeds);
        logicalPams.stream().map(pam -> (PrimaryAssetMember)this.mustBeTransitionedDirecltyContainedBy(pam.getId(), (EObject)physicalPa)).collect(Collectors.toList());
        this.checkPAMMembersTransitioned(BlockArchitectureExt.Type.PA);
    }

    private void checkSecurityNeedsProperlyTransitioned(SecurityNeeds transitionedSecurityNeeds) {
        PrimaryAssetTransitionTest.assertEquals((Object)this.securityNeeds.getConfidentialityValue(), (Object)transitionedSecurityNeeds.getConfidentialityValue());
        PrimaryAssetTransitionTest.assertEquals((Object)this.securityNeeds.getIntegrityValue(), (Object)transitionedSecurityNeeds.getIntegrityValue());
        PrimaryAssetTransitionTest.assertEquals((Object)this.securityNeeds.getTraceabilityValue(), (Object)transitionedSecurityNeeds.getTraceabilityValue());
        PrimaryAssetTransitionTest.assertEquals((Object)this.securityNeeds.getAvailabilityValue(), (Object)transitionedSecurityNeeds.getAvailabilityValue());
    }
}

