/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.common;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.cybersecurity.test.common.BasicDynamicModelTest;
import org.polarsys.capella.cybersecurity.test.common.ValidationHelpers;

public abstract class DynamicValidationTest
extends BasicDynamicModelTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
    }

    protected IStatus ok(EObject e, String ruleID) throws InterruptedException {
        IStatus status = ValidationHelpers.validate(e, ruleID);
        if (!status.isOK()) {
            StatusManager.getManager().handle(status, 1);
            DynamicValidationTest.fail((String)status.getMessage());
        }
        return status;
    }

    protected void ok(IStatus s) {
        DynamicValidationTest.assertTrue((boolean)s.isOK());
    }

    protected void ko(IStatus s) {
        DynamicValidationTest.assertFalse((boolean)s.isOK());
    }

    protected IStatus ko(EObject e, String ruleID) throws InterruptedException {
        IStatus status = ValidationHelpers.validate(e, ruleID);
        DynamicValidationTest.assertFalse((String)"Validator returned unexpected OK Status", (boolean)status.isOK());
        return status;
    }
}

