/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingutils.binding.Property;
import com.gradleware.tooling.toolingutils.binding.ValidationListener;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.binding.Validators;
import org.eclipse.buildship.core.util.collections.CollectionsUtils;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionValidator;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.ui.util.workbench.WorkbenchUtils;
import org.eclipse.buildship.ui.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ProjectImportWizardController {
    private static final String SETTINGS_KEY_PROJECT_DIR = "project_location";
    private static final String SETTINGS_KEY_GRADLE_DISTRIBUTION_TYPE = "gradle_distribution_type";
    private static final String SETTINGS_KEY_GRADLE_DISTRIBUTION_CONFIGURATION = "gradle_distribution_configuration";
    private static final String SETTINGS_KEY_JAVA_HOME = "java_home";
    private static final String SETTINGS_KEY_JVM_ARGUMENTS = "jvm_arguments";
    private static final String SETTINGS_KEY_ARGUMENTS = "arguments";
    private static final String SETTINGS_KEY_APPLY_WORKING_SETS = "apply_working_sets";
    private static final String SETTINGS_KEY_WORKING_SETS = "working_sets";
    private final ProjectImportConfiguration configuration;

    public ProjectImportWizardController(IWizard projectImportWizard) {
        Validator projectDirValidator = Validators.requiredDirectoryValidator((String)ProjectWizardMessages.Label_ProjectRootDirectory);
        Validator gradleDistributionValidator = GradleDistributionValidator.gradleDistributionValidator();
        Validator gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)ProjectWizardMessages.Label_GradleUserHome);
        Validator javaHomeValidator = Validators.optionalDirectoryValidator((String)ProjectWizardMessages.Label_JavaHome);
        Validator jvmArgumentsValidator = Validators.nullValidator();
        Validator argumentsValidator = Validators.nullValidator();
        Validator applyWorkingSetsValidator = Validators.nullValidator();
        Validator workingSetsValidator = Validators.nullValidator();
        this.configuration = new ProjectImportConfiguration(projectDirValidator, gradleDistributionValidator, gradleUserHomeValidator, javaHomeValidator, jvmArgumentsValidator, argumentsValidator, applyWorkingSetsValidator, workingSetsValidator);
        IDialogSettings dialogSettings = projectImportWizard.getDialogSettings();
        Optional projectDir = FileUtils.getAbsoluteFile((String)dialogSettings.get(SETTINGS_KEY_PROJECT_DIR));
        Optional gradleDistributionType = Optional.fromNullable((Object)Strings.emptyToNull((String)dialogSettings.get(SETTINGS_KEY_GRADLE_DISTRIBUTION_TYPE)));
        Optional gradleDistributionConfiguration = Optional.fromNullable((Object)Strings.emptyToNull((String)dialogSettings.get(SETTINGS_KEY_GRADLE_DISTRIBUTION_CONFIGURATION)));
        Optional gradleUserHome = Optional.fromNullable((Object)CorePlugin.workspaceConfigurationManager().loadWorkspaceConfiguration().getGradleUserHome());
        Optional javaHome = FileUtils.getAbsoluteFile((String)dialogSettings.get(SETTINGS_KEY_JAVA_HOME));
        Optional jvmArguments = Optional.fromNullable((Object)Strings.emptyToNull((String)dialogSettings.get(SETTINGS_KEY_JVM_ARGUMENTS)));
        Optional arguments = Optional.fromNullable((Object)Strings.emptyToNull((String)dialogSettings.get(SETTINGS_KEY_ARGUMENTS)));
        boolean applyWorkingSets = dialogSettings.get(SETTINGS_KEY_APPLY_WORKING_SETS) != null && dialogSettings.getBoolean(SETTINGS_KEY_APPLY_WORKING_SETS);
        ImmutableList workingSets = ImmutableList.copyOf((Object[])CollectionsUtils.nullToEmpty((String[])dialogSettings.getArray(SETTINGS_KEY_WORKING_SETS)));
        this.configuration.setProjectDir((File)projectDir.orNull());
        this.configuration.setGradleDistribution(this.createGradleDistribution((Optional<String>)gradleDistributionType, (Optional<String>)gradleDistributionConfiguration));
        this.configuration.setGradleUserHome((File)gradleUserHome.orNull());
        this.configuration.setJavaHome((File)javaHome.orNull());
        this.configuration.setJvmArguments((String)jvmArguments.orNull());
        this.configuration.setArguments((String)arguments.orNull());
        this.configuration.setApplyWorkingSets(Boolean.valueOf(applyWorkingSets));
        this.configuration.setWorkingSets((List)workingSets);
        this.saveFilePropertyWhenChanged(dialogSettings, SETTINGS_KEY_PROJECT_DIR, (Property<File>)this.configuration.getProjectDir());
        this.saveGradleWrapperPropertyWhenChanged(dialogSettings, (Property<GradleDistributionWrapper>)this.configuration.getGradleDistribution());
        this.saveFilePropertyWhenChanged(dialogSettings, SETTINGS_KEY_JAVA_HOME, (Property<File>)this.configuration.getJavaHome());
        this.saveStringPropertyWhenChanged(dialogSettings, SETTINGS_KEY_JVM_ARGUMENTS, (Property<String>)this.configuration.getJvmArguments());
        this.saveStringPropertyWhenChanged(dialogSettings, SETTINGS_KEY_ARGUMENTS, (Property<String>)this.configuration.getArguments());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_APPLY_WORKING_SETS, (Property<Boolean>)this.configuration.getApplyWorkingSets());
        this.saveStringArrayPropertyWhenChanged(dialogSettings, SETTINGS_KEY_WORKING_SETS, (Property<List<String>>)this.configuration.getWorkingSets());
    }

    private GradleDistributionWrapper createGradleDistribution(Optional<String> gradleDistributionType, Optional<String> gradleDistributionConfiguration) {
        GradleDistributionWrapper.DistributionType distributionType = GradleDistributionWrapper.DistributionType.valueOf((String)((String)gradleDistributionType.or((Object)GradleDistributionWrapper.DistributionType.WRAPPER.name())));
        String distributionConfiguration = (String)gradleDistributionConfiguration.orNull();
        return GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)distributionType, (String)distributionConfiguration);
    }

    private void saveBooleanPropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<Boolean> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(settingsKey, ((Boolean)target.getValue()).booleanValue());
            }
        });
    }

    private void saveStringPropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<String> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(settingsKey, (String)target.getValue());
            }
        });
    }

    private void saveStringArrayPropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<List<String>> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                List value = (List)target.getValue();
                settings.put(settingsKey, value.toArray(new String[value.size()]));
            }
        });
    }

    private void saveFilePropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<File> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(settingsKey, (String)FileUtils.getAbsolutePath((File)((File)target.getValue())).orNull());
            }
        });
    }

    private void saveGradleWrapperPropertyWhenChanged(final IDialogSettings settings, final Property<GradleDistributionWrapper> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(ProjectImportWizardController.SETTINGS_KEY_GRADLE_DISTRIBUTION_TYPE, ((GradleDistributionWrapper)target.getValue()).getType().name());
                settings.put(ProjectImportWizardController.SETTINGS_KEY_GRADLE_DISTRIBUTION_CONFIGURATION, ((GradleDistributionWrapper)target.getValue()).getConfiguration());
            }
        });
    }

    public ProjectImportConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean performImportProject(AsyncHandler initializer, NewProjectHandler newProjectHandler) {
        FixedRequestAttributes rootRequestAttributes = this.configuration.toFixedAttributes();
        ImportWizardNewProjectHandler workingSetsAddingNewProjectHandler = new ImportWizardNewProjectHandler(newProjectHandler, this.configuration);
        GradleBuild build = CorePlugin.gradleWorkspaceManager().getGradleBuild(rootRequestAttributes);
        if (initializer == AsyncHandler.NO_OP) {
            build.synchronize((NewProjectHandler)workingSetsAddingNewProjectHandler);
        } else {
            build.create((NewProjectHandler)workingSetsAddingNewProjectHandler, initializer);
        }
        return true;
    }

    private static final class ImportWizardNewProjectHandler
    implements NewProjectHandler {
        private final NewProjectHandler delegate;
        private final ProjectImportConfiguration configuration;
        private volatile boolean gradleViewsVisible;

        private ImportWizardNewProjectHandler(NewProjectHandler delegate, ProjectImportConfiguration configuration) {
            this.delegate = delegate;
            this.configuration = configuration;
        }

        public boolean shouldImport(OmniEclipseProject projectModel) {
            return this.delegate.shouldImport(projectModel);
        }

        public boolean shouldOverwriteDescriptor(IProjectDescription descriptor, OmniEclipseProject projectModel) {
            return this.delegate.shouldOverwriteDescriptor(descriptor, projectModel);
        }

        public void afterImport(IProject project, OmniEclipseProject projectModel) {
            this.delegate.afterImport(project, projectModel);
            this.addWorkingSets(project);
            this.ensureGradleViewsAreVisible();
        }

        private void addWorkingSets(IProject project) {
            ImmutableList workingSetNames = (Boolean)this.configuration.getApplyWorkingSets().getValue() != false ? ImmutableList.copyOf((Collection)((Collection)this.configuration.getWorkingSets().getValue())) : ImmutableList.of();
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet[] workingSets = WorkingSetUtils.toWorkingSets((List<String>)workingSetNames);
            workingSetManager.addToWorkingSets((IAdaptable)project, workingSets);
        }

        private void ensureGradleViewsAreVisible() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!gradleViewsVisible) {
                        gradleViewsVisible = true;
                        WorkbenchUtils.showView("org.eclipse.buildship.ui.views.taskview", null, 1);
                        WorkbenchUtils.showView("org.eclipse.buildship.ui.views.executionview", null, 2);
                    }
                }
            });
        }
    }
}

