/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import org.eclipse.buildship.ui.internal.PluginImage;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.util.action.CommandBackedAction;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.internal.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.internal.view.task.TaskViewActionStateRules;
import org.eclipse.buildship.ui.internal.view.task.TaskViewMessages;

public final class RunTasksAction
extends CommandBackedAction
implements SelectionSpecificAction {
    public RunTasksAction(String commandId) {
        super(commandId);
        this.setText(TaskViewMessages.Action_RunTasks_Text);
        this.setToolTipText(TaskViewMessages.Action_RunTasks_Tooltip);
        this.setImageDescriptor(PluginImages.RUN_TASKS.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
    }

    @Override
    public boolean isVisibleFor(NodeSelection selection) {
        return TaskViewActionStateRules.taskScopedTaskExecutionActionsVisibleFor(selection);
    }

    @Override
    public boolean isEnabledFor(NodeSelection selection) {
        return TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(selection).asBoolean();
    }

    @Override
    public void setEnabledFor(NodeSelection selection) {
        TaskViewActionStateRules.TaskScopedActionEnablement enablement = TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(selection);
        boolean isEnabled = enablement.asBoolean();
        this.setEnabled(isEnabled);
        this.setImageDescriptor(PluginImages.RUN_TASKS.withState(isEnabled ? PluginImage.ImageState.ENABLED : PluginImage.ImageState.DISABLED).getImageDescriptor());
        switch (enablement) {
            case ENABLED: {
                this.setText(TaskViewMessages.Action_RunTasks_Text);
                break;
            }
            case DISABLED_INCLUDED_BUILD: {
                this.setText(TaskViewMessages.Action_RunTasks_Text_Disabled_Included);
                break;
            }
            case DISABLED_NO_ROOT_PROJECT: {
                this.setText(TaskViewMessages.Action_RunTasks_Text_Disabled_NonStandard_layout);
                break;
            }
            default: {
                this.setText(TaskViewMessages.Action_RunTasks_Text_Disabled_Other);
            }
        }
    }
}

