/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.QueryTest;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class ResultSetTest
extends QueryTest {
    static String[] RESULTS = new String[]{"123, 1.212312, blah blah blah, 2000-09-01, 600", "14, 3.14, hahahahahahhahaha, 1991-10-02, 10", "0, 1.23, niem, 1979-11-28, 10", "null, null, null, null, null", "4, 12.3636, seven zero six, 2004-01-01, 10000"};
    private ResultSet m_resultSet;

    ResultSet getResultSet() {
        return this.m_resultSet;
    }

    @Before
    public void resultSetSetUp() throws Exception {
        this.getStatement().execute();
        this.m_resultSet = this.getStatement().getResultSet();
    }

    @After
    public void resultSetTearDown() throws Exception {
        this.m_resultSet.close();
    }

    public final void testGetResultSetMetaData() throws DataException {
        IResultClass metadata = this.m_resultSet.getMetaData();
        Assert.assertNotNull((Object)metadata);
        IResultClass metadata1 = this.m_resultSet.getMetaData();
        Assert.assertSame((Object)metadata, (Object)metadata1);
    }

    public final void testSetMaxRows() throws DataException {
        this.m_resultSet.setMaxRows(3);
        int count = 0;
        while (this.m_resultSet.fetch() != null) {
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    public final void testFetch() throws DataException {
        int rowPosition = 0;
        IResultObject resultObject = null;
        IResultClass resultClass = null;
        while ((resultObject = this.m_resultSet.fetch()) != null) {
            if (++rowPosition == 1) {
                resultClass = this.testResultClass(resultObject);
            }
            this.testFields(resultObject, resultClass, rowPosition);
        }
    }

    private IResultClass testResultClass(IResultObject resultObject) throws DataException {
        IResultClass resultClass = resultObject.getResultClass();
        Assert.assertNotNull((Object)resultClass);
        Assert.assertEquals((long)5L, (long)resultClass.getFieldCount());
        String[] fieldNames = resultClass.getFieldNames();
        Assert.assertNotNull((Object)fieldNames);
        int i = 0;
        while (i < 5) {
            String fieldName = fieldNames[i];
            Class fieldClass = resultClass.getFieldValueClass(fieldName);
            Assert.assertNotNull((Object)fieldClass);
            switch (i) {
                case 0: {
                    Assert.assertEquals((Object)"intColumn", (Object)fieldName);
                    Assert.assertEquals(Integer.class, (Object)fieldClass);
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"doubleColumn", (Object)fieldName);
                    Assert.assertEquals(Double.class, (Object)fieldClass);
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"stringColumn", (Object)fieldName);
                    Assert.assertEquals(String.class, (Object)fieldClass);
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)"dateColumn", (Object)fieldName);
                    Assert.assertEquals(Date.class, (Object)fieldClass);
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)"decimalColumn", (Object)fieldName);
                    Assert.assertEquals(BigDecimal.class, (Object)fieldClass);
                }
            }
            ++i;
        }
        return resultClass;
    }

    private void testFields(IResultObject resultObject, IResultClass resultClass, int rowPosition) throws DataException {
        String[] fieldNames = resultClass.getFieldNames();
        Object row = "";
        int i = 1;
        while (i <= resultClass.getFieldCount()) {
            Assert.assertEquals((Object)resultClass.getFieldName(i), (Object)fieldNames[i - 1]);
            Object value = resultObject.getFieldValue(i);
            if (i > 1) {
                row = (String)row + ", ";
            }
            row = (String)row + (value == null ? "null" : value.toString());
            ++i;
        }
        Assert.assertEquals((Object)RESULTS[rowPosition - 1], (Object)row);
    }

    public final void testGetRowPosition() throws DataException {
        int count = 0;
        while (this.m_resultSet.fetch() != null) {
            Assert.assertEquals((long)(++count), (long)this.m_resultSet.getRowPosition());
        }
    }

    public final void testRSClose() throws DataException {
        this.m_resultSet.close();
    }

    public final void testFetchWithHint() throws DataException, Exception {
        this.getStatement().close();
        ColumnHint columnHint = new ColumnHint("intColumn");
        columnHint.setDataType(Integer.class);
        columnHint.setNativeDataType(93);
        this.getStatement().addColumnHint(columnHint);
        this.getStatement().execute();
        this.m_resultSet = this.getStatement().getResultSet();
        int rowPosition = 0;
        IResultObject resultObject = null;
        IResultClass resultClass = null;
        while ((resultObject = this.m_resultSet.fetch()) != null) {
            if (++rowPosition == 1) {
                resultClass = this.testResultClass(resultObject);
            }
            this.testFields(resultObject, resultClass, rowPosition);
        }
    }
}

